/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dcd.model.settings;

import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="restricted_address", strict=false)
public class RestrictedAddress {
    @ElementList(inline=true)
    private List<Address> restrictedAddresses;

    protected RestrictedAddress() {
        this(new ArrayList<Address>());
    }

    public RestrictedAddress(List<Address> restrictedAddresses) {
        this.restrictedAddresses = new ArrayList<Address>(restrictedAddresses);
    }

    public List<Address> getRestrictedAddresses() {
        return this.restrictedAddresses;
    }

    public void setRestrictedAddresses(List<Address> restrictedAddresses) {
        this.restrictedAddresses = restrictedAddresses;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.restrictedAddresses);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestrictedAddress other = (RestrictedAddress)obj;
        return Objects.equals(this.restrictedAddresses, other.restrictedAddresses);
    }

    @Root(name="address", strict=false)
    public static class Address {
        @Attribute(name="id", required=true)
        private String id;
        @Attribute(name="lower_boundary", required=true)
        private String lowerBoundary;
        @Attribute(name="upper_boundary", required=true)
        private String upperBoundary;
        @ElementList(name="command_types", entry="command", empty=false, required=false)
        private List<String> commandTypes = new ArrayList<String>();

        public List<String> getCommandTypes() {
            return this.commandTypes;
        }

        public void setCommandTypes(List<String> commandTypes) {
            this.commandTypes = commandTypes;
        }

        protected Address() {
            this("", "", "", new ArrayList<String>());
        }

        public Address(String id, String lowerBoundary, String upperBoundary, List<String> commandTypes) {
            this.id = id;
            this.lowerBoundary = lowerBoundary;
            this.upperBoundary = upperBoundary;
            this.commandTypes = commandTypes;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getLowerBoundary() {
            return this.lowerBoundary;
        }

        public void setLowerBoundary(String lowerBoundary) {
            this.lowerBoundary = lowerBoundary;
        }

        public String getUpperBoundary() {
            return this.upperBoundary;
        }

        public void setUpperBoundary(String upperBoundary) {
            this.upperBoundary = upperBoundary;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Objects.hashCode(this.id);
            result = 31 * result + Objects.hashCode(this.lowerBoundary);
            result = 31 * result + Objects.hashCode(this.upperBoundary);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Address other = (Address)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.upperBoundary, other.upperBoundary) && Objects.equals(this.lowerBoundary, other.lowerBoundary);
        }

        @Commit
        public void commit() {
            if (this.commandTypes.isEmpty()) {
                this.commandTypes.add("write");
            }
        }
    }
}

