/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad;

import com.nxp.freertos.gdb.tad.controller.TadFactory;
import com.nxp.freertos.gdb.tad.strings.Texts;

public class ReadingException
extends Exception {
    private static final long serialVersionUID = 4803533038507621670L;
    private String args;

    public ReadingException() {
        super("Target Reading Exception");
    }

    public ReadingException(String args) {
        super("Target Reading Exception");
        this.args = args;
    }

    public String getSummary() {
        int lineNumber = 0;
        String methodName = Texts.get("Error.Unknown");
        String className = Texts.get("Error.Unknown");
        StackTraceElement[] stackTrace = this.getStackTrace();
        int i = 0;
        while (i < stackTrace.length) {
            if (stackTrace[i].getClassName().equals(TadFactory.class.getName()) && i + 1 < stackTrace.length) {
                methodName = stackTrace[i].getMethodName();
                className = stackTrace[i + 1].getClassName();
                lineNumber = stackTrace[i + 1].getLineNumber();
                break;
            }
            ++i;
        }
        return String.format("in class \"%s\" at %d. line when calling method \"%s(%s)\"", className, lineNumber, methodName, this.args != null ? this.args : "");
    }

    public String getArgs() {
        return this.args;
    }
}

