/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.controller;

import com.nxp.freertos.gdb.tad.Activator;
import com.nxp.freertos.gdb.tad.controller.TadFactoryData;
import com.nxp.freertos.gdb.tad.controller.TadFactoryDataStatus;
import com.nxp.freertos.gdb.tad.model.IDataListener;
import com.nxp.freertos.gdb.tad.model.ITadModelListener;
import com.nxp.freertos.gdb.tad.model.TadModel;
import com.nxp.freertos.gdb.tad.model.views.TadObject;
import com.nxp.freertos.gdb.tad.model.views.heapusage.Heap;
import com.nxp.freertos.gdb.tad.model.views.queuelist.Queue;
import com.nxp.freertos.gdb.tad.model.views.tasklist.Task;
import com.nxp.freertos.gdb.tad.model.views.timerlist.Timer;
import com.nxp.freertos.gdb.tad.view.TadView;
import com.nxp.freertos.gdb.tad.view.items.TadItem;
import com.nxp.freertos.gdb.tad.view.views.heapusage.HeapItem;
import com.nxp.freertos.gdb.tad.view.views.queuelist.QueueItem;
import com.nxp.freertos.gdb.tad.view.views.tasklist.TaskItem;
import com.nxp.freertos.gdb.tad.view.views.timerlist.TimerItem;
import java.util.LinkedList;

public class TadViewController
implements ITadModelListener,
IDataListener {
    private TadView view;
    private Object previousData;
    private final TadModel tadModel = Activator.getTadModel();

    public TadViewController(TadView view) {
        this.view = view;
        this.tadModel.addListener(this);
    }

    public void requestData() {
        this.tadModel.requestViewData(this, this.view.getTitle());
    }

    public boolean isDataReady() {
        return this.tadModel.getDataCache().isViewDataReady(this.view.getTitle());
    }

    public void dispose() {
        this.tadModel.removeListener(this);
    }

    @Override
    public void debuggerSuspended() {
        if (this.view != null && this.view.isVisible() && !this.view.isViewPaused()) {
            this.view.showProgressBar();
            this.view.enableAllActions(true);
            this.requestData();
        }
    }

    @Override
    public void debuggerTerminated() {
        if (this.view != null) {
            this.view.showTadView();
            this.view.clearData();
            this.view.enableAllActions(false);
            this.view.enableAllViewers(false);
        }
    }

    @Override
    public void debuggerResumed() {
        if (this.view != null && !this.view.isViewPaused()) {
            this.view.enableAllViewers(false);
        }
    }

    @Override
    public void debuggerSessionCreated() {
        if (this.view != null) {
            this.view.clearData();
            this.view.enableAllViewers(false);
        }
    }

    @Override
    public void dataCorrupted() {
        if (this.view != null) {
            this.view.showTadView();
            this.view.refreshData(null, false);
        }
    }

    @Override
    public void dataEmpty(TadFactoryData data) {
        this.view.showMessage(data.getStatus(), data.getMessage());
        this.view.enableAllViewers(false);
    }

    @Override
    public void dataReady(TadFactoryData data) {
        block18: {
            if (this.view == null || data == null || !data.isValid() || data.getStatus() != TadFactoryDataStatus.SUCCESS) break block18;
            if (this.previousData == data) {
                return;
            }
            this.previousData = data;
            LinkedList<TadItem> items = new LinkedList<TadItem>();
            int index = 1;
            for (TadObject tadObject : data.getTadObjects()) {
                switch (this.view.getTitle()) {
                    case "Task List": {
                        items.add(new TaskItem((Task)tadObject, index));
                        break;
                    }
                    case "Queue List": {
                        items.add(new QueueItem((Queue)tadObject, index));
                        break;
                    }
                    case "Timer List": {
                        items.add(new TimerItem((Timer)tadObject, index));
                        break;
                    }
                    case "Heap Usage": {
                        items.add(new HeapItem((Heap)tadObject));
                        break;
                    }
                }
                ++index;
            }
            boolean bl = items != null && !items.isEmpty();
            this.view.refreshData(items, bl);
            this.view.showTadView();
            this.view.enableAllViewers(bl);
        }
    }
}

