/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.controller.heapusage;

import com.nxp.freertos.gdb.tad.ReadingException;
import com.nxp.freertos.gdb.tad.controller.TadFactory;
import com.nxp.freertos.gdb.tad.controller.TadFactoryData;
import com.nxp.freertos.gdb.tad.controller.TadFactoryDataStatus;
import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOS;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSConfig;
import com.nxp.freertos.gdb.tad.model.readers.MemoryReader;
import com.nxp.freertos.gdb.tad.model.readers.VariableReader;
import com.nxp.freertos.gdb.tad.model.views.TadDataCache;
import com.nxp.freertos.gdb.tad.model.views.TadObject;
import com.nxp.freertos.gdb.tad.model.views.heapusage.Heap;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapBlock;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapBlockStatus;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapRegion;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapType;
import com.nxp.freertos.gdb.tad.model.views.queuelist.Queue;
import com.nxp.freertos.gdb.tad.model.views.tasklist.Task;
import com.nxp.freertos.gdb.tad.strings.Texts;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class HeapFactory
extends TadFactory {
    private TadDataCache dataCache;
    private long ucHeapAddress;

    public HeapFactory(MemoryReader memoryReader, VariableReader variableReader, FreeRTOS freeRTOS, TadDataCache dataCache) {
        super(memoryReader, variableReader, freeRTOS);
        this.dataCache = dataCache;
    }

    private synchronized HeapType identifyHeapType() {
        long heapStructSize = this.readIntVariableSafely("xHeapStructSize");
        if (this.ucHeapAddress != -1L) {
            Logger.info(String.format(Texts.get("Info.HeapVariable"), "ucHeap", this.ucHeapAddress));
            if (heapStructSize != -1L) {
                Logger.info(String.format(Texts.get("Info.HeapVariable"), "xHeapStructSize", heapStructSize));
                return HeapType.HEAP_4;
            }
            try {
                this.readIntVariable("heapSTRUCT_SIZE");
                return HeapType.HEAP_2;
            }
            catch (ReadingException readingException) {
                return HeapType.HEAP_1;
            }
        }
        if (heapStructSize != -1L) {
            try {
                this.getSize(FreeRTOS.HEAP_REGIONS);
                return HeapType.HEAP_5;
            }
            catch (ReadingException readingException) {
                return HeapType.HEAP_4;
            }
        }
        if (this.readAddressOfVariableSafely("_pvHeapStart") != -1L) {
            return HeapType.HEAP_NEWLIB;
        }
        if (this.freeRTOS.isMacroEnabled(FreeRTOSConfig.STATIC_AND_DYNAMIC_ALLOCATION)) {
            return HeapType.STATIC_MEMORY;
        }
        return HeapType.HEAP_3;
    }

    @Override
    public synchronized TadFactoryData getData() {
        LinkedList<Heap> list = new LinkedList<Heap>();
        try {
            HeapType heapType = this.freeRTOS.getHeapType();
            if (heapType == HeapType.HEAP_3) {
                return new TadFactoryData(list, TadFactoryDataStatus.INFORMATION, String.valueOf(Texts.get("Info.HeapNoInfo")) + "\n\nNOTE: " + Texts.get("Info.HeapTypeIdentifyHelp"));
            }
            this.ucHeapAddress = this.readAddressOfVariableSafely("ucHeap");
            if (heapType == HeapType.UNKNOWN) {
                int typeNum = -1;
                if (heapType == HeapType.UNKNOWN && (typeNum = this.readIntVariableSafely("freeRTOSMemoryScheme")) != -1 && HeapType.valueOf(typeNum) != HeapType.UNKNOWN) {
                    this.freeRTOS.enableMacro(FreeRTOSConfig.MEMORY_SCHEME, true);
                    heapType = HeapType.valueOf(typeNum);
                    Logger.info(String.format(Texts.get("Info.HeapIdentifiedFrom"), "freeRTOSMemoryScheme variable (configFRTOS_MEMORY_SCHEME)", heapType.toString()));
                }
                if (heapType == HeapType.UNKNOWN) {
                    Logger.info(Texts.get("Info.HeapTypeIdentifyFromVariable"));
                    Logger.info(Texts.get("Info.HeapTypeIdentifyHelp"));
                    this.freeRTOS.enableMacro(FreeRTOSConfig.MEMORY_SCHEME, false);
                    heapType = this.identifyHeapType();
                    Logger.info(String.format(Texts.get("Info.HeapIdentifiedFrom"), "available heap variables", heapType.toString()));
                }
                this.freeRTOS.setHeapType(heapType);
            }
            Heap heap = new Heap(heapType);
            switch (this.freeRTOS.getHeapType()) {
                case HEAP_1: {
                    heap.setHeapStart(this.ucHeapAddress);
                    long heapSize = this.getSize("ucHeap");
                    heap.setHeapEnd(this.ucHeapAddress + heapSize);
                    long nextFreeByte = this.readLongVariable("xNextFreeByte");
                    heap.setFree(heapSize - nextFreeByte);
                    heap.setUsed(heapSize - heap.getFree());
                    break;
                }
                case UNKNOWN: 
                case STATIC_MEMORY: 
                case HEAP_3: {
                    return new TadFactoryData(list, TadFactoryDataStatus.INFORMATION, String.valueOf(Texts.get("Info.HeapNoInfo")) + "\n\nNOTE: " + Texts.get("Info.HeapTypeIdentifyHelp"));
                }
                case HEAP_2: 
                case HEAP_4: 
                case HEAP_5: {
                    long xStartPtr;
                    long heapSize = 0L;
                    long xStartAddress = this.readAddressOfVariable("xStart");
                    long free = this.readIntVariable("xFreeBytesRemaining");
                    heap.setFree(free);
                    if (heapType != HeapType.HEAP_5) {
                        heap.setHeapStart(this.ucHeapAddress);
                        heapSize = this.getSize("ucHeap");
                        heap.setHeapEnd(this.ucHeapAddress + heapSize);
                    } else {
                        long heapRegionsSize = 0L;
                        try {
                            heapRegionsSize = this.getSize(FreeRTOS.HEAP_REGIONS);
                        }
                        catch (ReadingException readingException) {
                            return new TadFactoryData(list, TadFactoryDataStatus.INFORMATION, Texts.get("Info.Heap5RegionsUndef"));
                        }
                        long numberOfHeapRegions = heapRegionsSize / this.getStructSize(this.freeRTOS.getStruct("heap_region"));
                        LinkedList<HeapRegion> regions = new LinkedList<HeapRegion>();
                        int i = 0;
                        while ((long)i < numberOfHeapRegions) {
                            long heapRegionAddress = this.readAddressOfVariable(String.valueOf(FreeRTOS.HEAP_REGIONS) + "[" + i + "]");
                            long size = this.readLongAtAddress(heapRegionAddress, this.freeRTOS.getStruct("heap_region"), "xSizeInBytes");
                            if (size > 0L) {
                                heapSize += size;
                                long startAddress = this.readLongAtAddress(heapRegionAddress, this.freeRTOS.getStruct("heap_region"), "pucStartAddress");
                                regions.add(new HeapRegion(startAddress, size));
                            }
                            ++i;
                        }
                        heap.setHeap5regions(this.sortHeapRegionsByAddress(regions));
                        long heapStart = regions.size() > 0 ? ((HeapRegion)regions.get(0)).getStartAddress() : xStartAddress;
                        heap.setHeapStart(heapStart);
                        long heapEnd = regions.size() > 0 ? ((HeapRegion)regions.get(regions.size() - 1)).getEndAddress() : heapStart + heapSize;
                        heap.setHeapEnd(heapEnd);
                    }
                    heap.setUsed(heapSize - free);
                    if (heapType != HeapType.HEAP_2) {
                        heap.setMinFree(this.readIntVariable("xMinimumEverFreeBytesRemaining"));
                    }
                    if (xStartAddress <= 0L || (xStartPtr = this.readLongAtAddress(xStartAddress, this.freeRTOS.getStruct("heap_block"), "pxNextFreeBlock")) == 0L || heap.getSize() <= 0L) break;
                    List<HeapBlock> blocks = this.sortHeapBlocksByAddress(this.getHeapBlocks(xStartPtr, heap.getHeapEnd()));
                    blocks = this.sortHeapBlocksByAddress(this.addAllocatedBlocks(blocks, heap.getHeapStart()));
                    if (heapType == HeapType.HEAP_5) {
                        for (HeapRegion region : heap.getHeap5regions()) {
                            long usage = 0L;
                            List<HeapBlock> regionBlocks = new LinkedList<HeapBlock>();
                            for (HeapBlock block : blocks) {
                                if (block.getStartAddress() > region.getEndAddress()) break;
                                if (block.getEndAddress() < region.getStartAddress()) continue;
                                long overflow = 0L;
                                if (block.getStartAddress() >= region.getStartAddress() && block.getEndAddress() <= region.getEndAddress()) {
                                    regionBlocks.add(block);
                                } else if (block.getEndAddress() > region.getEndAddress()) {
                                    overflow = block.getEndAddress() - region.getEndAddress();
                                    regionBlocks.add(new HeapBlock(block.getStartAddress(), block.getSize() - overflow, block.getStatus()));
                                } else {
                                    overflow = region.getStartAddress() - block.getStartAddress();
                                    regionBlocks.add(new HeapBlock(region.getStartAddress(), block.getSize() - overflow, block.getStatus()));
                                }
                                if (block.getStatus() != HeapBlockStatus.ALLOCATED) continue;
                                usage += block.getSize() - overflow;
                            }
                            regionBlocks = this.addAllocatedBlocks(regionBlocks, region.getStartAddress());
                            region.setUsed(usage);
                            region.setHeapBlocks(regionBlocks);
                        }
                        blocks.clear();
                        for (HeapRegion region : heap.getHeap5regions()) {
                            for (HeapBlock block : region.getHeapBlocks()) {
                                blocks.add(block);
                            }
                        }
                    }
                    heap.setHeapBlocks(this.sortHeapBlocksByAddress(blocks));
                    break;
                }
                case HEAP_NEWLIB: {
                    long heapBase = this.readAddressOfVariableSafely("_pvHeapStart");
                    long heapEnd = this.readAddressOfVariableSafely("_pvHeapLimit");
                    int remainingBytes = this.readIntVariableSafely("heapBytesRemaining");
                    if (heapBase == -1L || heapEnd == -1L || remainingBytes == -1) {
                        return new TadFactoryData(list, TadFactoryDataStatus.INFORMATION, Texts.get("Info.HeapNewlibNoInfo"));
                    }
                    heap.setHeapStart(heapBase);
                    heap.setHeapEnd(heapEnd);
                    heap.setFree(remainingBytes);
                    heap.setUsed(heapEnd - heapBase - heap.getFree());
                }
            }
            list.add(heap);
        }
        catch (ReadingException e) {
            Logger.exception(e, e.getSummary());
            return new TadFactoryData(list, TadFactoryDataStatus.WARNING, String.format(String.valueOf(Texts.get("Error.CouldNotGetHeapFactoryData")) + "\n" + Texts.get("Info.HeapTypeIdentifyHelp"), "Heap Usage", this.freeRTOS.getHeapType().getType()));
        }
        return new TadFactoryData(list, TadFactoryDataStatus.SUCCESS, null);
    }

    private List<HeapBlock> sortHeapBlocksByAddress(List<HeapBlock> blocks) {
        Collections.sort(blocks, new Comparator<HeapBlock>(){

            @Override
            public int compare(HeapBlock block1, HeapBlock block2) {
                if (block1.getStartAddress() < block2.getStartAddress()) {
                    return -1;
                }
                if (block1.getStartAddress() > block2.getStartAddress()) {
                    return 1;
                }
                return 0;
            }
        });
        return blocks;
    }

    private List<HeapRegion> sortHeapRegionsByAddress(List<HeapRegion> regions) {
        Collections.sort(regions, new Comparator<HeapRegion>(){

            @Override
            public int compare(HeapRegion region1, HeapRegion region2) {
                if (region1.getStartAddress() < region2.getStartAddress()) {
                    return -1;
                }
                if (region1.getStartAddress() > region2.getStartAddress()) {
                    return 1;
                }
                return 0;
            }
        });
        return regions;
    }

    private List<HeapBlock> addAllocatedBlocks(List<HeapBlock> blocks, long heapStart) {
        if (blocks != null && blocks.size() > 0) {
            int i = 0;
            while (i < blocks.size() - 1) {
                HeapBlock block = blocks.get(i);
                HeapBlock nextBlock = blocks.get(i + 1);
                if (block.getEndAddress() + 1L < nextBlock.getStartAddress()) {
                    blocks.add(++i, new HeapBlock(block.getEndAddress() + 1L, nextBlock.getStartAddress() - block.getEndAddress() - 1L, HeapBlockStatus.ALLOCATED));
                }
                ++i;
            }
            HeapBlock firstBlock = blocks.get(0);
            if (heapStart + 1L < firstBlock.getStartAddress()) {
                blocks.add(0, new HeapBlock(heapStart, firstBlock.getStartAddress() - heapStart, HeapBlockStatus.ALLOCATED));
            }
        }
        return blocks;
    }

    private synchronized List<HeapBlock> getHeapBlocks(long nextFreeBlock, long heapEnd) throws ReadingException {
        List<? extends TadObject> queues;
        LinkedList<HeapBlock> blocks = new LinkedList<HeapBlock>();
        while (nextFreeBlock != 0L && nextFreeBlock < heapEnd) {
            long blockSize = this.readLongAtAddress(nextFreeBlock, this.freeRTOS.getStruct("heap_block"), "xBlockSize");
            if (blockSize > 0L && blockSize <= heapEnd - nextFreeBlock) {
                blocks.add(new HeapBlock(nextFreeBlock, blockSize, HeapBlockStatus.FREE));
            }
            nextFreeBlock = this.readLongAtAddress(nextFreeBlock, this.freeRTOS.getStruct("heap_block"), "pxNextFreeBlock");
        }
        List<? extends TadObject> tasks = this.dataCache.getViewTadObjects("Task List");
        if (tasks != null && !tasks.isEmpty()) {
            long sizeOfTCB = this.getStructSize(this.freeRTOS.getStruct("task_control_block"));
            for (TadObject tadObject : tasks) {
                Task task = (Task)tadObject;
                blocks.add(new HeapBlock(task.getAddress(), sizeOfTCB, HeapBlockStatus.ALLOCATED, String.valueOf(task.getName()) + " (" + Texts.get("Label.Task") + " " + Texts.get("Label.Task.TCB") + ")"));
                blocks.add(new HeapBlock(task.getStack().getBaseAddress(), task.getStack().getSize(), HeapBlockStatus.ALLOCATED, String.valueOf(task.getName()) + " (" + Texts.get("Label.Task") + " " + Texts.get("Label.Task.Stack") + ")"));
            }
        }
        if ((queues = this.dataCache.getViewTadObjects("Queue List")) != null && !queues.isEmpty()) {
            long queueStructSize = this.getStructSize(this.freeRTOS.getStruct("queue"));
            for (TadObject tadObject : queues) {
                Queue queue = (Queue)tadObject;
                blocks.add(new HeapBlock(queue.getAddress(), queueStructSize + (long)queue.getDataSize(), HeapBlockStatus.ALLOCATED, String.valueOf(queue.getName()) + " (" + Texts.get("Label.Queue") + ")"));
            }
        }
        return blocks;
    }
}

