/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.logger;

import com.nxp.freertos.gdb.tad.Activator;
import com.nxp.freertos.gdb.tad.logger.Log;
import com.nxp.freertos.gdb.tad.logger.LogType;
import com.nxp.freertos.gdb.tad.model.Time;
import com.nxp.freertos.gdb.tad.strings.Texts;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.console.MessageConsoleStream;

public class Logger {
    private static List<Log> logs;
    private static final int STORED_LOG_COUNT = 3;
    private static MessageConsoleStream tadConsoleStream;

    private static synchronized void log(Log log) {
        if (logs == null) {
            logs = new LinkedList<Log>();
            tadConsoleStream = Activator.getTadModel().getTadConsole().newMessageStream();
        }
        logs.add(log);
        tadConsoleStream.println(log.toString());
    }

    public static synchronized void info(String text) {
        Logger.log(new Log(LogType.INFO, text));
    }

    public static synchronized void debug(String text, Object ... args) {
        Logger.log(new Log(LogType.DEBUG, String.format(text, args)));
    }

    public static synchronized void error(String text) {
        Logger.log(new Log(LogType.ERROR, text));
    }

    public static synchronized void exception(Exception e, String message) {
        Logger.log(new Log(e, message));
    }

    public static synchronized void exception(Exception e) {
        Logger.log(new Log(LogType.EXCEPTION, e.getClass().getSimpleName()));
    }

    public static void clear() {
        if (logs != null) {
            logs.clear();
        }
    }

    public static Log[] getLogs() {
        if (!logs.isEmpty()) {
            return logs.toArray(new Log[logs.size()]);
        }
        return new Log[0];
    }

    public static void saveLogFile() {
        block18: {
            File workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            if (workspace != null && workspace.exists()) {
                File tadLogsDir = new File(workspace, Texts.get("Log.DirName"));
                try {
                    if (!tadLogsDir.exists() && !tadLogsDir.mkdir()) {
                        Logger.error(String.format(Texts.get("Error.LogDirNotCreated"), tadLogsDir.getAbsolutePath()));
                        return;
                    }
                }
                catch (SecurityException e) {
                    Logger.exception(e, Texts.get("Exception.WhileSavingLog"));
                }
                Logger.deleteOldLogFiles(tadLogsDir);
                try {
                    String logName = String.valueOf(Texts.get("Log.SaveName")) + Time.SAVE_FORMAT.toString() + Texts.get("Log.FileExtension");
                    File logPath = new File(tadLogsDir, logName);
                    if (logPath == null) break block18;
                    try {
                        Throwable throwable = null;
                        Object var5_9 = null;
                        try (OutputStreamWriter txt = new OutputStreamWriter((OutputStream)new FileOutputStream(logPath), StandardCharsets.UTF_8);){
                            txt.write(String.format("\"%s\" %s %s", Texts.get("General.Tad"), Texts.get("General.Version"), Activator.getVersionAsString()));
                            txt.write(System.getProperty("line.separator"));
                            txt.write(Texts.get("General.Copyright"));
                            txt.write(System.getProperty("line.separator"));
                            txt.write("==================================");
                            txt.write(System.getProperty("line.separator"));
                            for (Log msg : logs) {
                                txt.write(msg.toString());
                                txt.write(System.getProperty("line.separator"));
                            }
                            ((Writer)txt).close();
                            Logger.info(String.format(Texts.get("Log.Saved"), logPath));
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        Logger.exception(e, null);
                    }
                }
                catch (NullPointerException e) {
                    Logger.exception(e, null);
                }
            }
        }
    }

    public static void deleteOldLogFiles(File directory) {
        Object[] files = null;
        try {
            files = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name != null && dir != null && dir.isDirectory()) {
                        return name.contains(Texts.get("Log.FileExtension"));
                    }
                    return false;
                }
            });
        }
        catch (SecurityException e) {
            Logger.exception(e, String.format(Texts.get("Exception.CouldNotAccess"), directory));
        }
        if (files != null && files.length > 3) {
            try {
                Arrays.sort(files);
            }
            catch (ClassCastException e) {
                Logger.exception(e, Texts.get("Exception.ElementsNotComparable"));
            }
            File[] fileArray = (File[])Arrays.copyOfRange(files, 0, files.length - 3);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    file.delete();
                }
                catch (SecurityException e) {
                    Logger.exception(e, Texts.get("Exception.CouldNotAccess"));
                }
                ++n2;
            }
        }
    }
}

