/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.model;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Auxiliary {
    public static final Color LIGHT_GREEN_COLOUR = new Color((Device)Display.getCurrent(), new RGB(120.0f, 1.0f, 0.9f));
    public static final Color GREEN_COLOUR = new Color((Device)Display.getCurrent(), new RGB(130.0f, 1.0f, 0.7f));
    public static final Color RED_COLOUR = new Color((Device)Display.getCurrent(), new RGB(360.0f, 1.0f, 1.0f));
    public static final Color WHITE_COLOUR = new Color((Device)Display.getCurrent(), new RGB(255, 255, 255));
    public static final Color BLACK_COLOUR = new Color((Device)Display.getCurrent(), new RGB(0, 0, 0));

    public static final String capitalize(String word) {
        return word != null && word.length() > 1 ? String.valueOf(word.substring(0, 1).toUpperCase()) + word.substring(1).toLowerCase() : null;
    }

    public static final String yesNo(boolean value) {
        return value ? "Yes" : "No";
    }

    public static final double getPercentage(Long part, Long size) {
        if (part != null && size != null && size > 0L) {
            return (double)part.longValue() / (double)size.longValue() * 100.0;
        }
        return 0.0;
    }

    public static final String toASCII(Long number) {
        StringBuilder builder = new StringBuilder();
        int size = (int)Math.ceil((double)Long.toBinaryString(number).length() / 8.0);
        int i = 0;
        while (i < size) {
            builder.append((char)(number >> 8 * i & 0xFFL));
            ++i;
        }
        return builder.toString();
    }

    public static final Color getContrastColor(Color colour) {
        double luminance = 1.0 - (0.299 * (double)colour.getRed() + 0.587 * (double)colour.getGreen() + 0.114 * (double)colour.getBlue()) / 255.0;
        if (luminance < 0.5) {
            return BLACK_COLOUR;
        }
        return WHITE_COLOUR;
    }
}

