/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.model.freertos;

import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSAvailability;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSConfig;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapType;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskStackGrowth;
import com.nxp.freertos.gdb.tad.strings.Texts;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Version;

public class FreeRTOS {
    public static final String READY_TASK_LISTS = "pxReadyTasksLists";
    public static final String PENDING_READY_TASK_LIST = "xPendingReadyList";
    public static final String SUSPENDED_TASK_LIST = "xSuspendedTaskList";
    public static final String DELAYED_TASK_LIST_1 = "pxDelayedTaskList";
    public static final String DELAYED_TASK_LIST_2 = "pxOverflowDelayedTaskList";
    public static final String TIMER_LIST_1 = "pxCurrentTimerList";
    public static final String TIMER_LIST_2 = "pxOverflowTimerList";
    public static final String HEAP_STRUCT_SIZE = "xHeapStructSize";
    public static final String HEAP2_STRUCT_SIZE = "heapSTRUCT_SIZE";
    public static final String HEAP_ARRAY = "ucHeap";
    public static final String HEAP_START_LINKER = "_pvHeapStart";
    public static final String HEAP_END_LINKER = "_pvHeapLimit";
    public static final String HEAP_BYTES_REMAINING = "heapBytesRemaining";
    public static final String HEAP_MIN_FREE_BYTES = "xMinimumEverFreeBytesRemaining";
    public static final String HEAP_FREE_BYTES = "xFreeBytesRemaining";
    public static final String HEAP_NEXT_FREE_BYTE = "xNextFreeByte";
    public static final String HEAP_START_FREE_BLOCKS = "xStart";
    public static String HEAP_REGIONS = "xHeapRegions";
    public static final String TASK_CONTROL_BLOCK_10_1_0 = "TaskControlBlock_t";
    public static final Version FREERTOS_VERSION_10_1_0 = new Version(10, 1, 0);
    public static final Version FREERTOS_VERSION_10_2_0 = new Version(10, 2, 0);
    public static final String FREERTOS_DEBUG_CONFIG = "FreeRTOSDebugConfig";
    public static final int FREERTOS_VERSION_MAJOR_OFFSET = 2;
    public static final int FREERTOS_VERSION_MINOR_OFFSET = 3;
    public static final int FREERTOS_VERSION_BUILD_OFFSET = 4;
    public static final int FREERTOS_MEMORY_SCHEME_OFFSET = 5;
    public static final String LIST_ITEM = "list_item";
    public static final String TASK_CONTROL_BLOCK = "task_control_block";
    public static final String QUEUE = "queue";
    public static final String QUEUE_REGISTRY_ITEM = "queue_registr_item";
    public static final String QUEUE_POINTERS = "queue_pointers";
    public static final String TIMER = "timer";
    public static final String HEAP_BLOCK = "heap_block";
    public static final String HEAP_REGION = "heap_region";
    private long runtime;
    private HeapType heapType;
    private Long queueRegistrySize;
    private TaskStackGrowth taskStackGrowth;
    private FreeRTOSAvailability availability;
    private Version version;
    private Map<FreeRTOSConfig, Boolean> config = new HashMap<FreeRTOSConfig, Boolean>();
    private Map<String, String> structs = new HashMap<String, String>();

    public FreeRTOS() {
        this.version = new Version(0, 0, 0);
        this.init();
    }

    public void init() {
        this.heapType = HeapType.UNKNOWN;
        this.queueRegistrySize = null;
        this.taskStackGrowth = TaskStackGrowth.UNKNOWN;
        this.availability = FreeRTOSAvailability.UNKNOWN;
        this.config.put(FreeRTOSConfig.RUNTIME_STATS, true);
        this.config.put(FreeRTOSConfig.USE_MUTEXES, true);
        this.config.put(FreeRTOSConfig.USE_TRACE, true);
        this.config.put(FreeRTOSConfig.RECORD_STACK_HIGH_ADDRESS, true);
        this.config.put(FreeRTOSConfig.MEMORY_SCHEME, true);
        this.config.put(FreeRTOSConfig.STATIC_AND_DYNAMIC_ALLOCATION, false);
    }

    public void initStructs(Version version) {
        this.structs.clear();
        this.version = version;
        this.structs.put(LIST_ITEM, "xLIST_ITEM");
        this.structs.put(QUEUE_REGISTRY_ITEM, "QUEUE_REGISTRY_ITEM");
        this.structs.put(HEAP_BLOCK, "A_BLOCK_LINK");
        this.structs.put(HEAP_REGION, "HeapRegion");
        if (version.compareTo(FREERTOS_VERSION_10_1_0) == 0) {
            this.structs.put(TASK_CONTROL_BLOCK, TASK_CONTROL_BLOCK_10_1_0);
            this.structs.put(QUEUE, "QueueDef_t");
            this.structs.put(TIMER, "TimerDef_t");
            this.structs.put(QUEUE_POINTERS, "QueuePointers");
        } else {
            this.structs.put(TASK_CONTROL_BLOCK, "tskTaskControlBlock");
            this.structs.put(QUEUE, "QueueDefinition");
            this.structs.put(TIMER, "tmrTimerControl");
        }
    }

    public long getRuntime() {
        return this.runtime;
    }

    public void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    public HeapType getHeapType() {
        return this.heapType;
    }

    public void setHeapType(HeapType heapType) {
        this.heapType = heapType;
    }

    public Long getQueueRegistrySize() {
        return this.queueRegistrySize;
    }

    public void setQueueRegistrySize(Long queueRegistrySize) {
        this.queueRegistrySize = queueRegistrySize;
    }

    public TaskStackGrowth getTaskStackGrowth() {
        return this.taskStackGrowth;
    }

    public void setTaskStackGrowth(TaskStackGrowth taskStackGrowth) {
        this.taskStackGrowth = taskStackGrowth;
    }

    public boolean isMacroEnabled(FreeRTOSConfig macro) {
        return this.config.get((Object)macro);
    }

    public void enableMacro(FreeRTOSConfig macro, boolean enable) {
        if (!enable) {
            Logger.info(String.format(Texts.get("Info.MacroDisabled"), macro.toString()));
        }
        this.config.put(macro, enable);
    }

    public FreeRTOSAvailability getAvailability() {
        return this.availability;
    }

    public void setAvailability(FreeRTOSAvailability availability) {
        if (availability != FreeRTOSAvailability.AVAILABLE) {
            Logger.info(Texts.get("Info.FreeRTOSNotUsed"));
        }
        this.availability = availability;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isOlderThan(Version version) {
        return this.version.compareTo(version) < 0;
    }

    public boolean isNewerThan(Version version) {
        return this.version.compareTo(version) > 0;
    }

    public String getStruct(String key) {
        return this.structs.get(key);
    }
}

