/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.model.state;

import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.state.DMEvent;
import com.nxp.freertos.gdb.tad.model.state.TadStates;
import com.nxp.freertos.gdb.tad.strings.Texts;
import org.eclipse.cdt.dsf.debug.service.IRunControl;

public class TadState {
    private TadStates tadState = TadStates.NONE;

    public void shiftState(DMEvent event, IRunControl.StateChangeReason reason) {
        String oldTadState = this.tadState.toString();
        switch (this.tadState) {
            case DEBUG_STARTED: {
                this.tadState = TadStates.DEBUG_INIT_0;
                break;
            }
            case DEBUG_INIT_0: {
                this.tadState = TadStates.DEBUG_INIT_1;
                break;
            }
            case DEBUG_INIT_1: {
                this.tadState = TadStates.DEBUG_SUSPENDED;
                break;
            }
            case DEBUG_SUSPENDED: {
                if (event != DMEvent.RESUMED) break;
                this.tadState = TadStates.DEBUG_RESUMED;
                break;
            }
            case DEBUG_RESUMED: {
                if (event != DMEvent.SUSPENDED) break;
                this.tadState = TadStates.READY;
                break;
            }
            case READY: {
                this.tadState = TadStates.DEBUG_RESUMED;
                break;
            }
            default: {
                this.tadState = TadStates.DEBUG_INIT_0;
            }
        }
        Logger.info(String.valueOf(Texts.get("State.Change")) + oldTadState + " -> " + this.tadState.toString() + " (" + event.toString() + ", " + reason.toString() + ")");
    }

    public boolean isReady() {
        return this.tadState == TadStates.READY;
    }

    public boolean isDebugRunning() {
        return this.tadState != TadStates.NONE;
    }

    public void debugStarted(boolean started) {
        this.tadState = started ? TadStates.DEBUG_STARTED : TadStates.NONE;
    }
}

