/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.model.views.queuelist;

import com.nxp.freertos.gdb.tad.model.views.TadObject;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueData;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueType;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueWaitingTask;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueWaitingTaskOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Queue
extends TadObject {
    private String name;
    private long address;
    private long head;
    private long tail;
    private long writeTo;
    private long readFrom;
    private long currentLength;
    private long maxLength;
    private QueueType type;
    private Map<QueueWaitingTaskOperation, QueueWaitingTask> waitingTasks;
    private int dataSize;
    private int dataItemSize;
    private List<QueueData> data;

    public Queue(long handleAddress, String name, long maxLength, long currentLength, int dataItemSize, long headAddress, long tailAddress, long readFromAddress, long writeToAddress) {
        this.address = handleAddress;
        this.name = name;
        this.maxLength = maxLength;
        this.currentLength = currentLength;
        this.dataItemSize = dataItemSize;
        this.head = headAddress;
        this.tail = tailAddress;
        this.readFrom = readFromAddress;
        this.writeTo = writeToAddress;
        this.dataSize = (int)(currentLength > 0L && dataItemSize > 0 ? currentLength * (long)dataItemSize : 0L);
        this.waitingTasks = new HashMap<QueueWaitingTaskOperation, QueueWaitingTask>();
    }

    public String getName() {
        return this.name;
    }

    public long getAddress() {
        return this.address;
    }

    public long getHead() {
        return this.head;
    }

    public long getTail() {
        return this.tail;
    }

    public long getWriteTo() {
        return this.writeTo;
    }

    public long getReadFrom() {
        return this.readFrom;
    }

    public void setType(QueueType type) {
        this.type = type;
    }

    public QueueType getType() {
        return this.type;
    }

    public long getCurrentLength() {
        return this.currentLength;
    }

    public long getMaxLength() {
        return this.maxLength;
    }

    public int getDataItemSize() {
        return this.dataItemSize;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public List<QueueData> getData() {
        return this.data;
    }

    public void setData(List<QueueData> data) {
        this.data = data;
    }

    public Map<QueueWaitingTaskOperation, QueueWaitingTask> getWaitingTasks() {
        return this.waitingTasks;
    }

    public void addWaitingTask(QueueWaitingTaskOperation operation, QueueWaitingTask waitingTask) {
        this.waitingTasks.put(operation, waitingTask);
    }
}

