/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.model.views.queuelist;

import com.nxp.freertos.gdb.tad.model.Auxiliary;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueDataType;
import java.math.BigInteger;
import java.util.List;

public class QueueData {
    public static final int BYTES_TO_READ = 4;
    private int id;
    private long address;
    private List<Long> listData;
    private BigInteger rawData;

    public QueueData(int id, long address, List<Long> data) {
        this.id = id;
        this.address = address;
        this.listData = data;
        this.rawData = new BigInteger("0");
        for (Long item : data) {
            this.rawData = this.rawData.add(new BigInteger(Long.toString(item)));
        }
    }

    public int getId() {
        return this.id;
    }

    public long getAddress() {
        return this.address;
    }

    public boolean hasData() {
        return this.listData != null && !this.listData.isEmpty();
    }

    public List<Long> getData() {
        return this.listData;
    }

    public String toString(QueueDataType type) {
        StringBuilder builder = new StringBuilder();
        switch (type) {
            case DECIMAL: {
                builder.append(String.format("%d", this.rawData));
                break;
            }
            case BINARY: {
                builder.append(this.rawData.toString(2));
                break;
            }
            case ASCII: {
                for (long number : this.listData) {
                    builder.append(Auxiliary.toASCII(number));
                }
                break;
            }
            default: {
                builder.append(String.format("0x%08x", this.rawData));
            }
        }
        return builder.toString();
    }
}

