/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.model.views.timerlist;

import com.nxp.freertos.gdb.tad.model.Auxiliary;
import com.nxp.freertos.gdb.tad.model.views.TadObject;
import com.nxp.freertos.gdb.tad.model.views.timerlist.TimerCallback;
import com.nxp.freertos.gdb.tad.model.views.timerlist.TimerStatus;
import java.util.LinkedList;

public class Timer
extends TadObject {
    private long address;
    private String name;
    private int id;
    private Long number;
    private long periodInTicks;
    private TimerStatus status;
    private TimerCallback callback;

    public Timer(long address, String name, int id, Long number, long periodInTicks, TimerStatus status, TimerCallback callback) {
        this.address = address;
        this.name = name;
        this.id = id;
        this.number = number;
        this.periodInTicks = periodInTicks;
        this.status = status;
        this.callback = callback;
    }

    public long getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public Long getNumber() {
        return this.number;
    }

    public long getPeriod() {
        return this.periodInTicks;
    }

    public String getStatus() {
        LinkedList<String> str = new LinkedList<String>();
        if (this.status.active) {
            str.add("active");
        }
        if (this.status.staticallyAllocated) {
            str.add("static");
        }
        if (this.status.autoReload) {
            str.add("autoreload");
        }
        if (str.size() > 0) {
            return Auxiliary.capitalize(String.join((CharSequence)", ", str));
        }
        return "Unknown";
    }

    public TimerCallback getCallback() {
        return this.callback;
    }
}

