/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.items;

import com.nxp.freertos.gdb.tad.strings.Separator;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public abstract class TadItem {
    protected final int index;

    public TadItem(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public TadItem getParent() {
        return null;
    }

    public boolean isParent() {
        return this.getParent() == null;
    }

    public List<? extends TadItem> getChildItems() {
        return null;
    }

    public boolean hasChildItems() {
        return this.getChildItems() != null && !this.getChildItems().isEmpty();
    }

    public List<? extends TadItem> getTreeChildren() {
        return null;
    }

    public boolean hasTreeChildren() {
        return this.getTreeChildren() != null && !this.getTreeChildren().isEmpty();
    }

    public abstract String getText(TadColumnId var1);

    public Image getImage(TadColumnId column) {
        return null;
    }

    public Long getNumValue(TadColumnId column) {
        return null;
    }

    public abstract String toString(Separator var1);

    protected String toString(TadColumnId[] columns, Separator separator) {
        StringBuilder line = new StringBuilder();
        TadColumnId[] tadColumnIdArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TadColumnId column = tadColumnIdArray[n2];
            String value = this.getText(column);
            if (value != null) {
                line.append(value);
            }
            line.append(separator.toString());
            ++n2;
        }
        return line.toString();
    }

    public boolean isValid() {
        return true;
    }

    public int getTextColour() {
        return 2;
    }

    public static final String formatBytes(long bytes) {
        float number = bytes;
        String[] stringArray = new String[]{"B", "kB", "MB"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            if (!(number >= 1024.0f)) {
                return String.valueOf(new DecimalFormat("###0.##").format(number)) + " " + unit;
            }
            number = (float)((double)number / 1024.0);
            ++n2;
        }
        return String.format("%d B", bytes);
    }
}

