/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.providers;

import com.nxp.freertos.gdb.tad.Activator;
import com.nxp.freertos.gdb.tad.model.TadModel;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOS;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSConfig;
import com.nxp.freertos.gdb.tad.strings.Texts;
import com.nxp.freertos.gdb.tad.view.column.TadColumn;
import com.nxp.freertos.gdb.tad.view.items.TadItem;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class TadItemColumnLabelProvider
extends ColumnLabelProvider {
    private TadColumn column;
    private FreeRTOSConfig dependency;
    private FreeRTOS freeRTOS;

    public TadItemColumnLabelProvider(TadColumn column) {
        this.column = column;
        this.dependency = column.getDependency();
        this.freeRTOS = Activator.getTadModel().getFreeRTOS();
    }

    public Image getImage(Object element) {
        if (element instanceof TadItem) {
            TadItem item = (TadItem)element;
            if (item.isParent() && this.dependency != null) {
                if (this.dependency.getInfo() != null && !this.freeRTOS.isMacroEnabled(this.dependency)) {
                    return TadModel.INFORMATION_IMG_DESC.createImage();
                }
                if (item.getText(this.column.getId()) == null) {
                    return TadModel.WARNING_IMG;
                }
            }
            return item.getImage(this.column.getId());
        }
        return null;
    }

    public String getToolTipText(Object element) {
        TadItem item;
        if (element instanceof TadItem && (item = (TadItem)element).isParent() && this.dependency != null) {
            if (this.dependency.getInfo() != null && !this.freeRTOS.isMacroEnabled(this.dependency)) {
                return this.dependency.getInfo();
            }
            if (item.getText(this.column.getId()) == null) {
                return String.format(Texts.get("Warning.Dependency"), this.dependency.toString(), this.column.getName());
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof TadItem) {
            return ((TadItem)element).getText(this.column.getId());
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof TadItem) {
            TadItem item = (TadItem)element;
            if (item.getTextColour() != 0) {
                return Display.getCurrent().getSystemColor(item.getTextColour());
            }
            if (!item.isValid()) {
                return Display.getCurrent().getSystemColor(3);
            }
        }
        return null;
    }
}

