/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.BuildStepUpdateStatus;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.BuilderAttributeUpdateStatus;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.LaunchConfigurationAttributeUpdateStatus;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.OptionUpdateStatus;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.SourceEntriesUpdateStatus;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.ProjectConfigurationCoreActivator;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class UpdateStatus
extends Status {
    public static final String CONFIG_ELEMENT = "config";
    public static final String CONFIG_NAME_ATTRIBUTE = "name";
    public static final String UPDATE_STATUS_OLD_VALUE_ATTRIBUTE = "oldValue";
    public static final String UPDATE_STATUS_NEW_VALUE_ATTRIBUTE = "newValue";
    public static final String UPDATE_STATUS_SKIPPED_VALUE_ATTRIBUTE = "skippedValue";
    private String configurationName;
    private Collection<String> sourceValues;
    private Collection<String> targetValues;
    private Collection<String> skippedValues;

    public UpdateStatus(String configurationName, String message) {
        super(0, ProjectConfigurationCoreActivator.getInstance().getBundleId(), message);
        this.configurationName = Objects.requireNonNull(configurationName);
        this.sourceValues = new LinkedHashSet<String>();
        this.targetValues = new LinkedHashSet<String>();
        this.skippedValues = new LinkedHashSet<String>();
    }

    protected UpdateStatus(Element updateStatusElement, String configurationName) {
        this(configurationName, "");
        this.initializeAttributesFromXml(updateStatusElement);
    }

    public abstract String getIdentifier();

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setSourceValues(Collection<String> sourceValues) {
        this.sourceValues.addAll(sourceValues);
    }

    public void setSourceValue(String sourceValue) {
        this.sourceValues.add(sourceValue);
    }

    public Collection<String> getSourceValues() {
        return this.sourceValues;
    }

    public void setTargetValues(Collection<String> targetValues) {
        this.targetValues.addAll(targetValues);
    }

    public void setTargetValue(String targetValue) {
        this.targetValues.add(targetValue);
    }

    public Collection<String> getTargetValues() {
        return this.targetValues;
    }

    public void setSkippedValues(Collection<String> skippedValues) {
        this.skippedValues.addAll(skippedValues);
    }

    public Collection<String> getSkippedValues() {
        return this.skippedValues;
    }

    public Element convertToXml(Document document, Element holderElement) {
        Element element = document.createElement(CONFIG_ELEMENT);
        element.setAttribute(CONFIG_NAME_ATTRIBUTE, this.configurationName);
        holderElement.appendChild(element);
        return element;
    }

    public static UpdateStatus createUpdateStatus(Element updateStatusElement, String configurationName) {
        String updateStatusElementName;
        switch (updateStatusElementName = updateStatusElement.getNodeName()) {
            case "sourceEntries": {
                return new SourceEntriesUpdateStatus(updateStatusElement, configurationName);
            }
            case "builderAttribute": {
                return new BuilderAttributeUpdateStatus(updateStatusElement, configurationName);
            }
            case "buildStep": {
                return new BuildStepUpdateStatus(updateStatusElement, configurationName);
            }
            case "launchAttribute": {
                return new LaunchConfigurationAttributeUpdateStatus(updateStatusElement, configurationName);
            }
            case "option": {
                return new OptionUpdateStatus(updateStatusElement, configurationName);
            }
        }
        throw new IllegalArgumentException("Unknown update status element: " + updateStatusElementName);
    }

    protected void convertAttributesToXml(Element holderElement) {
        holderElement.setAttribute(UPDATE_STATUS_OLD_VALUE_ATTRIBUTE, String.join((CharSequence)",", this.sourceValues));
        holderElement.setAttribute(UPDATE_STATUS_NEW_VALUE_ATTRIBUTE, String.join((CharSequence)",", this.targetValues));
        holderElement.setAttribute(UPDATE_STATUS_SKIPPED_VALUE_ATTRIBUTE, String.join((CharSequence)",", this.skippedValues));
    }

    protected void initializeAttributesFromXml(Element element) {
        this.sourceValues = UpdateStatus.parseListElementAttribute(element, UPDATE_STATUS_OLD_VALUE_ATTRIBUTE);
        this.targetValues = UpdateStatus.parseListElementAttribute(element, UPDATE_STATUS_NEW_VALUE_ATTRIBUTE);
        this.skippedValues = UpdateStatus.parseListElementAttribute(element, UPDATE_STATUS_SKIPPED_VALUE_ATTRIBUTE);
    }

    private static Collection<String> parseListElementAttribute(Element element, String attributeName) {
        return Arrays.stream(element.getAttribute(attributeName).split(",")).map(String::trim).filter(value -> !value.isEmpty()).collect(Collectors.toSet());
    }
}

