/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.internal.core.checkers;

import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.ProjectConfigurationCoreActivator;
import com.nxp.s32ds.ext.cdt.core.checker.IResourceChecker;
import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PexFileProjectResourceChecker
implements IResourceChecker {
    private static final String TEXT_TO_SEARCH = "/S32DS/S32_SDK_S32PA_RTM_3.0.0";
    private static final String TEXT_TO_REPLACE = "/S32DS/software/S32_SDK_S32PA_RTM_3.0.0";

    public IStatus check(IResource resource, final IProgressMonitor monitor) {
        if (!(resource instanceof IProject)) {
            return Status.OK_STATUS;
        }
        IProject project = (IProject)resource;
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IProject || resource instanceof IFolder) {
                        return true;
                    }
                    if (resource instanceof IFile) {
                        PexFileProjectResourceChecker.updateFile((IFile)resource, monitor);
                    }
                    return false;
                }
            });
        }
        catch (CoreException e) {
            ProjectConfigurationCoreActivator.getInstance().logError("An error occurred during the update.", e);
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private static void updateFile(IFile file, IProgressMonitor monitor) throws CoreException {
        String changed;
        String fileContents = WorkspaceResources.getFileContents((IFile)file);
        if (!fileContents.equals(changed = fileContents.replace(TEXT_TO_SEARCH, TEXT_TO_REPLACE))) {
            WorkspaceResources.setFileContents((IFile)file, (String)changed, (IProgressMonitor)monitor);
        }
    }
}

