/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.internal.core.checkers;

import com.nxp.s32ds.cle.cdt.project.configuration.core.validators.ProjectSettingsValidators;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.ProjectConfigurationCoreActivator;
import com.nxp.s32ds.ext.cdt.core.checker.IResourceChecker;
import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ToolchainNameInProjectResourceChecker
implements IResourceChecker {
    private static final String FILE_TO_CHECK = ".cproject";
    private static final String TEXT_TO_SEARCH = "com.nxp.s32ds.cle.arm.mbs.arm32.bare.tool\u0441hain";
    private static final String TEXT_TO_REPLACE = "com.nxp.s32ds.cle.arm.mbs.arm32.bare.toolchain";
    private static final int MARKER_DELETION_DELAY = 300;

    public IStatus check(IResource resource, IProgressMonitor monitor) {
        if (!(resource instanceof IProject)) {
            return Status.OK_STATUS;
        }
        IProject project = (IProject)resource;
        if (!ProjectSettingsValidators.hasSettings(project)) {
            return Status.OK_STATUS;
        }
        IFile file = project.getFile(FILE_TO_CHECK);
        try {
            if (ToolchainNameInProjectResourceChecker.updateFile(file, monitor)) {
                ProjectUpdaterServiceJob job = new ProjectUpdaterServiceJob(Messages.ToolchainNameInProjectResourceChecker_project_marker_updating_job, project);
                job.schedule(300L);
            }
        }
        catch (CoreException e) {
            ProjectConfigurationCoreActivator.getInstance().logError("An error occurred during the update.", e);
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private static boolean updateFile(IFile file, IProgressMonitor monitor) throws CoreException {
        String changed;
        String fileContents = WorkspaceResources.getFileContents((IFile)file);
        if (fileContents.equals(changed = fileContents.replace(TEXT_TO_SEARCH, TEXT_TO_REPLACE))) {
            return false;
        }
        WorkspaceResources.setFileContents((IFile)file, (String)changed, (IProgressMonitor)monitor);
        return true;
    }

    private static class ProjectUpdaterServiceJob
    extends WorkspaceJob {
        IProject project;

        public ProjectUpdaterServiceJob(String jobName, IProject project) {
            super(jobName);
            this.setSystem(true);
            this.setUser(false);
            this.project = project;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            IStatus status = Status.OK_STATUS;
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = this.project.findMarkers("org.eclipse.core.resources.problemmarker", true, 1);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    Map attrs = marker.getAttributes();
                    if (attrs.containsValue("Program \"gcc\" not found in PATH") || attrs.containsValue("Program \"g++\" not found in PATH")) {
                        marker.delete();
                    }
                    ++n2;
                }
            }
            catch (CoreException ex) {
                status = ProjectConfigurationCoreActivator.getInstance().createError(ex.getMessage(), ex);
            }
            return status;
        }
    }
}

