/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.internal.ui.wizard;

import com.nxp.s32ds.cle.ide.migration.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrationLogger;
import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequenceDescriptor;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationStep;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class MigrationDescriptorsUtil {
    private static final String ID = "id";
    private static final String PROJECT = "project";

    public static IRunnableWithProgress getMigrationOperation(final List<IProject> projects, final MigrationSequenceDescriptor descriptor) {
        return new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)descriptor.getName(), (int)projects.size());
                for (IProject project : projects) {
                    MigrationDescriptorsUtil.migrate(project, descriptor, (IProgressMonitor)subMonitor.split(1));
                }
            }
        };
    }

    private static void migrate(IProject project, MigrationSequenceDescriptor sequenceDescriptor, IProgressMonitor monitor) throws CoreException {
        List steps = sequenceDescriptor.getSequence().getMigrationSteps(project, new MigrationDiagnostic(project));
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.MigrationDescriptorsUtil_migrate_project_0, (Object)project.getName()), (int)steps.size());
        MigrationLogger.wrapCoreException(MigrationDescriptorsUtil.sequenceLogEntry(sequenceDescriptor, project), () -> {
            for (MigrationStep step : steps) {
                subMonitor.subTask(step.getName());
                MigrationLogger.wrapCoreException(MigrationDescriptorsUtil.stepLogEntry(step, project), () -> step.perform((IProgressMonitor)subMonitor));
                subMonitor.worked(1);
            }
        });
    }

    private static MigrationLogger.LogEntry sequenceLogEntry(MigrationSequenceDescriptor sequenceDescriptor, IProject project) {
        return MigrationLogger.logEntry(sequenceDescriptor.getName(), MigrationLogger.strings(ID, PROJECT), MigrationLogger.strings(sequenceDescriptor.getId(), project.getName()));
    }

    private static MigrationLogger.LogEntry stepLogEntry(MigrationStep step, IProject project) {
        return MigrationLogger.logEntry(step.getName(), MigrationLogger.strings(PROJECT), MigrationLogger.strings(project.getName()));
    }
}

