/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.internal.ui.wizard;

import com.nxp.s32ds.cle.ide.migration.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.migration.internal.ui.MigrationUiActivator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;

public class MigrationLogger {
    public static void wrapCoreException(LogEntry logEntry, Executable executable) throws CoreException {
        try {
            MigrationLogger.wrap(logEntry, executable);
        }
        catch (Throwable e) {
            if (e instanceof CoreException) {
                throw (CoreException)e;
            }
            MigrationLogger.throwsUnchecked(e);
        }
    }

    public static void wrap(LogEntry logEntry, Executable executable) {
        try {
            executable.exec();
            MigrationUiActivator.getInstance().logInfo(NLS.bind((String)Messages.MigrationLogger_0_completed_successfully1, (Object)logEntry.name, (Object)logEntry.args));
        }
        catch (Throwable e) {
            if (e instanceof OperationCanceledException) {
                MigrationUiActivator.getInstance().logInfo(NLS.bind((String)Messages.MigrationLogger_0_canceled1, (Object)logEntry.name, (Object)logEntry.args));
            } else {
                MigrationUiActivator.getInstance().logError(NLS.bind((String)Messages.MigrationLogger_0_failed1, (Object)logEntry.name, (Object)logEntry.args), e);
            }
            MigrationLogger.throwsUnchecked(e);
        }
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable toThrow) throws T {
        throw toThrow;
    }

    public static LogEntry logEntry(String name, String[] argsNames, Object[] argsValues) {
        if (argsNames.length != argsValues.length) {
            throw new IllegalStateException("Different number of names and values");
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < argsNames.length) {
            builder.append(NLS.bind((String)Messages.MigrationDescriptorsUtil_br_0_1, (Object)argsNames[i], (Object)argsValues[i]));
            ++i;
        }
        return new LogEntry(name, builder.toString());
    }

    public static String[] strings(String ... strings) {
        return strings;
    }

    public static Object[] objects(Object ... objects) {
        return objects;
    }

    public static interface Executable {
        public void exec() throws Throwable;
    }

    public static class LogEntry {
        public final String name;
        public final String args;

        public LogEntry(String name, String args) {
            this.name = name;
            this.args = args;
        }
    }
}

