/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.diagnostic;

import com.nxp.s32ds.cle.ide.migration.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.migration.internal.ui.MigrationUiActivator;
import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnosticElementType;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public enum MigrationDiagnosticEnum {
    ROOT{

        @Override
        public String getText(MigrationDiagnostic element) {
            return MigrationUiActivator.getWorkbenchLabelProvider().getText(element.getValue());
        }

        @Override
        public Image getImage(MigrationDiagnostic element) {
            return MigrationUiActivator.getWorkbenchLabelProvider().getImage(element.getValue());
        }
    }
    ,
    SEQUENCE{

        @Override
        public String getText(MigrationDiagnostic element) {
            return element.getName();
        }

        @Override
        public Image getImage(MigrationDiagnostic element) {
            return MigrationUiActivator.getInstance().getImage("icon_sequence");
        }
    }
    ,
    ACTION{

        @Override
        public String getText(MigrationDiagnostic element) {
            return element.getName();
        }
    }
    ,
    SUB_SEQUENCE_ACTION{

        @Override
        public String getText(MigrationDiagnostic element) {
            return element.getName();
        }
    }
    ,
    CONDITION{

        @Override
        public String getText(MigrationDiagnostic element) {
            Object value = element.getValue();
            if (value instanceof IStatus) {
                return NLS.bind((String)Messages.MigrationDiagnosticEnum_aassertion_failed_0, (Object)((IStatus)value).getMessage());
            }
            return NLS.bind((String)Messages.MigrationDiagnosticEnum_test_0_1, (Object)element.getName(), (Object)String.valueOf(value));
        }

        @Override
        public Image getImage(MigrationDiagnostic element) {
            return MigrationUiActivator.getInstance().getImage("icon_condition");
        }
    }
    ,
    PROPERTY{

        @Override
        public String getText(MigrationDiagnostic element) {
            return NLS.bind((String)Messages.MigrationDiagnosticEnum_0_eq_1, (Object)element.getName(), (Object)element.getValue());
        }

        @Override
        public Image getImage(MigrationDiagnostic element) {
            return MigrationUiActivator.getInstance().getImage("icon_property");
        }
    }
    ,
    BOOLEAN_VARIABLE{

        @Override
        public String getText(MigrationDiagnostic element) {
            return NLS.bind((String)Messages.MigrationDiagnosticEnum_0_eq_1, (Object)element.getName(), (Object)element.getValue());
        }

        @Override
        protected Stream<MigrationDiagnostic> flatChildren(MigrationDiagnostic diagnostic) {
            return diagnostic.getChildren().stream();
        }
    }
    ,
    AND_EXPRESSION{

        @Override
        public String getText(MigrationDiagnostic element) {
            return NLS.bind((String)Messages.MigrationDiagnosticEnum_operator_and_0, (Object)element.getValue());
        }

        @Override
        public Image getImage(MigrationDiagnostic element) {
            return MigrationUiActivator.getInstance().getImage("icon_operator");
        }
    }
    ,
    OR_EXPRESSION{

        @Override
        public String getText(MigrationDiagnostic element) {
            return NLS.bind((String)Messages.MigrationDiagnosticEnum_operator_or_0, (Object)element.getValue());
        }

        @Override
        public Image getImage(MigrationDiagnostic element) {
            return MigrationUiActivator.getInstance().getImage("icon_operator");
        }
    }
    ,
    NOT_EXPRESSION{

        @Override
        public String getText(MigrationDiagnostic element) {
            return NLS.bind((String)Messages.MigrationDiagnosticEnum_operator_not_0, (Object)element.getValue());
        }

        @Override
        public Image getImage(MigrationDiagnostic element) {
            return MigrationUiActivator.getInstance().getImage("icon_operator");
        }
    };


    public Image getImage(MigrationDiagnostic element) {
        return null;
    }

    public abstract String getText(MigrationDiagnostic var1);

    public MigrationDiagnostic[] getChildren(MigrationDiagnostic parentElement) {
        return (MigrationDiagnostic[])parentElement.getChildren().stream().flatMap(d -> MigrationDiagnosticEnum.doSwitch(d).flatChildren((MigrationDiagnostic)d)).toArray(MigrationDiagnostic[]::new);
    }

    protected Stream<MigrationDiagnostic> flatChildren(MigrationDiagnostic diagnostic) {
        return Stream.of(diagnostic);
    }

    public MigrationDiagnostic getParent(MigrationDiagnostic element) {
        MigrationDiagnostic parent = element.getParent();
        if (parent == null) {
            return null;
        }
        switch (parent.getType()) {
            case BOOLEAN_VARIABLE: {
                return parent.getParent();
            }
        }
        return parent;
    }

    public boolean hasChildren(MigrationDiagnostic element) {
        switch (element.getType()) {
            case BOOLEAN_VARIABLE: {
                return false;
            }
        }
        return this.getChildren(element).length > 0;
    }

    public static MigrationDiagnosticEnum doSwitch(MigrationDiagnostic diagnostic) {
        MigrationDiagnosticElementType type = diagnostic.getType();
        switch (type) {
            case ROOT: {
                return ROOT;
            }
            case SEQUENCE: {
                return SEQUENCE;
            }
            case ACTION: {
                return ACTION;
            }
            case SUB_SEQUENCE_ACTION: {
                return SUB_SEQUENCE_ACTION;
            }
            case CONDITION: {
                return CONDITION;
            }
            case PROPERTY: {
                return PROPERTY;
            }
            case BOOLEAN_VARIABLE: {
                return BOOLEAN_VARIABLE;
            }
            case AND_EXPRESSION: {
                return AND_EXPRESSION;
            }
            case OR_EXPRESSION: {
                return OR_EXPRESSION;
            }
            case NOT_EXPRESSION: {
                return NOT_EXPRESSION;
            }
        }
        throw new IllegalStateException("Unknown type " + type);
    }
}

