/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core;

import com.freescale.s32ds.cdt.core.FSLErrorParserExtensionManager;
import com.freescale.s32ds.cdt.core.ICompilationPathResolver;
import com.freescale.s32ds.cdt.core.IErrorParserManagerDelegate;
import com.freescale.s32ds.cdt.core.IErrorParserProcessor;
import com.freescale.s32ds.cdt.core.IFSLErrorParser3;
import com.freescale.s32ds.cdt.core.OutputLine;
import com.freescale.s32ds.cdt.core.OutputLineQueue;
import com.freescale.s32ds.cdt.core.internal.errorparsers.CompilationPathResolverManager;
import com.freescale.s32ds.cdt.core.internal.errorparsers.ErrorParserDelegateManager;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IErrorParser2;
import org.eclipse.cdt.core.IErrorParser3;
import org.eclipse.cdt.core.IErrorParserNamed;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.errorparsers.ErrorParserNamedWrapper;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.internal.core.Cygwin;
import org.eclipse.cdt.internal.core.IErrorMarkeredOutputStream;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.osgi.service.prefs.BackingStoreException;

public class FSLErrorParserManager
extends ErrorParserManager
implements IConsoleParser,
IWorkingDirectoryTracker,
IErrorParserProcessor {
    private static final String EMPTY_STRING = "";
    public static final char S32DS_ERROR_PARSER_DELIMITER = ';';
    @Deprecated
    public static final String S32DS_PREF_ERROR_PARSER = "org.eclipse.cdt.core.errorOutputParser";
    public static final String S32DS_BUILD_CONTEXT = "build";
    private int numberOpens;
    private int lineCounter = 0;
    private final IProject project;
    private final IMarkerGenerator markerGenerator;
    private Collection<IErrorParser> collectionsOfErrorParsers;
    private List<ProblemMarkerInfo> listOfErrors;
    private List<ProblemMarkerInfo> listOfPendingErrors;
    private final Deque<URI> directoryStack;
    private IErrorParserManagerDelegate[] delegates;
    private ICompilationPathResolver[] resolvers;
    private final URI baseDirectoryURI;
    private IErrorParser3 previousErrorParser = null;
    private String previousLine;
    private OutputStream outputStream;
    private final StringBuilder currentLine = new StringBuilder();
    private final StringBuilder scratchBuffer = new StringBuilder();
    private boolean hasErrors = false;
    private String cachedFileName = null;
    private URI cachedWorkingDirectory = null;
    private IFile cachedFile = null;
    private static boolean isCygwin = true;
    private List<String> listOfErrorMsgLines = new ArrayList<String>();
    private boolean isErrorMsgComplete = false;
    private final OutputLineQueue outputLineQueue = new OutputLineQueue();

    public FSLErrorParserManager(ACBuilder builder) {
        this(builder.getProject(), (IMarkerGenerator)builder);
    }

    public FSLErrorParserManager(IProject project, IMarkerGenerator markerGenerator) {
        this(project, markerGenerator, null);
    }

    public FSLErrorParserManager(IProject project, IMarkerGenerator markerGenerator, String[] parsersIds) {
        this(project, (URI)null, markerGenerator, parsersIds);
    }

    @Deprecated
    public FSLErrorParserManager(IProject project, IPath workingDirectory, IMarkerGenerator markerGenerator, String[] parsersIds) {
        this(project, workingDirectory != null || workingDirectory.isEmpty() ? null : URIUtil.toURI((IPath)workingDirectory), markerGenerator, parsersIds);
    }

    public FSLErrorParserManager(IProject project, URI baseDirectoryURI, IMarkerGenerator markerGenerator, String[] parsersIds) {
        super(project, baseDirectoryURI, markerGenerator, parsersIds);
        this.project = project;
        this.markerGenerator = markerGenerator;
        this.directoryStack = new ArrayDeque<URI>();
        this.listOfErrors = new ArrayList<ProblemMarkerInfo>();
        this.listOfPendingErrors = new ArrayList<ProblemMarkerInfo>();
        if (parsersIds == null) {
            parsersIds = FSLErrorParserExtensionManager.getDefaultErrorParserIds();
        }
        this.collectionsOfErrorParsers = Stream.of(parsersIds).map(FSLErrorParserManager::getErrorParserCopy).filter(Objects::nonNull).collect(Collectors.toList());
        this.baseDirectoryURI = baseDirectoryURI != null ? baseDirectoryURI : (project != null ? project.getLocationURI() : URIUtil.toURI((String)System.getProperty("user.dir")));
        this.resolvers = CompilationPathResolverManager.getResolvers();
        IErrorParserManagerDelegate[] iErrorParserManagerDelegateArray = this.delegates = ErrorParserDelegateManager.getDelegates();
        int n = this.delegates.length;
        int n2 = 0;
        while (n2 < n) {
            IErrorParserManagerDelegate delegate = iErrorParserManagerDelegateArray[n2];
            delegate.initialize(this);
            ++n2;
        }
    }

    @Override
    public Collection<IErrorParser> getErrorParsers() {
        return this.collectionsOfErrorParsers;
    }

    public IProject getProject() {
        return this.project;
    }

    @Deprecated
    public IPath getWorkingDirectory() {
        return URIUtil.toPath((URI)this.getWorkingDirectoryURI());
    }

    public URI getWorkingDirectoryURI() {
        if (!this.directoryStack.isEmpty()) {
            return this.directoryStack.getLast();
        }
        return this.baseDirectoryURI;
    }

    public void pushDirectory(IPath path) {
        if (path != null) {
            URI uri;
            URI workingDirectoryURI = this.getWorkingDirectoryURI();
            if (!path.isAbsolute()) {
                uri = org.eclipse.core.runtime.URIUtil.append((URI)workingDirectoryURI, (String)path.toString());
            } else {
                uri = this.toURI(path);
                if (uri == null) {
                    return;
                }
            }
            this.pushDirectoryURI(uri);
        }
    }

    public void pushDirectoryURI(URI uri) {
        if (uri != null) {
            if (uri.isAbsolute()) {
                this.directoryStack.add(uri);
            } else {
                this.directoryStack.add(org.eclipse.core.runtime.URIUtil.makeAbsolute((URI)uri, (URI)this.getWorkingDirectoryURI()));
            }
        }
    }

    @Deprecated
    public IPath popDirectory() {
        return URIUtil.toPath((URI)this.popDirectoryURI());
    }

    public URI popDirectoryURI() {
        if (!this.directoryStack.isEmpty()) {
            return this.directoryStack.pollLast();
        }
        return this.baseDirectoryURI;
    }

    public int getDirectoryLevel() {
        return this.directoryStack.size();
    }

    @Deprecated
    protected void collectFiles(IProject parent, List<IResource> result) {
        try {
            parent.accept(proxy -> {
                if (proxy.getType() == 1) {
                    result.add(proxy.requestResource());
                    return false;
                }
                return true;
            }, 0);
        }
        catch (CoreException e) {
            CCorePlugin.log((IStatus)e.getStatus());
        }
    }

    public boolean processLine(String line) {
        this.registerOutputLine(line);
        IErrorParserManagerDelegate[] iErrorParserManagerDelegateArray = this.delegates;
        int n = this.delegates.length;
        int n2 = 0;
        while (n2 < n) {
            IErrorParserManagerDelegate delegate = iErrorParserManagerDelegateArray[n2];
            if (delegate.processLine(line, this)) {
                return true;
            }
            ++n2;
        }
        return this.processErrorParsers(line, this.collectionsOfErrorParsers);
    }

    public void registerOutputLine(String line) {
        this.registerOutputLine(line, false);
    }

    public void registerOutputLine(String line, boolean duplicated) {
        this.outputLineQueue.add(new OutputLine(line, duplicated));
    }

    @Override
    public boolean processErrorParsers(String line, Collection<IErrorParser> parsers) {
        ++this.lineCounter;
        int sizeBeforeCycle = this.listOfErrorMsgLines.size();
        String trimLine = line.trim();
        ProblemMarkerInfo marker = null;
        for (IErrorParser errorParser : parsers) {
            int emptyType;
            int parserTypes = 0;
            IErrorParser currentErrorParser = errorParser;
            if (errorParser instanceof ErrorParserNamedWrapper) {
                currentErrorParser = ((ErrorParserNamedWrapper)errorParser).getErrorParser();
            }
            if (currentErrorParser instanceof IErrorParser2) {
                parserTypes = ((IErrorParser2)currentErrorParser).getProcessLineBehaviour();
            }
            if ((parserTypes & 4) == (emptyType = 0)) {
                int longLine = 1000;
                if (trimLine.length() > longLine) continue;
            }
            String parsedLine = trimLine;
            if ((parserTypes & 1) != emptyType) {
                parsedLine = line;
            } else {
                this.outputLineQueue.registerAlias(line, trimLine);
            }
            boolean result = false;
            try {
                try {
                    result = currentErrorParser.processLine(parsedLine, (ErrorParserManager)this);
                }
                catch (Exception e) {
                    String id = EMPTY_STRING;
                    if (errorParser instanceof IErrorParserNamed) {
                        id = ((IErrorParserNamed)errorParser).getId();
                    }
                    String message = MessageFormat.format("Errorparser {0} failed parsing line [{1}]", id, parsedLine);
                    CCorePlugin.log((String)message, (Throwable)e);
                }
                if (result) {
                    if (this.previousErrorParser instanceof IFSLErrorParser3 && this.previousErrorParser != currentErrorParser) {
                        List<ProblemMarkerInfo> temporaryErrors = this.listOfPendingErrors;
                        this.listOfPendingErrors = new ArrayList<ProblemMarkerInfo>();
                        ((IFSLErrorParser3)this.previousErrorParser).flush(this);
                        this.listOfPendingErrors.addAll(temporaryErrors);
                    }
                    this.previousErrorParser = currentErrorParser instanceof IErrorParser3 ? (IErrorParser3)currentErrorParser : null;
                    this.flushPendingErrors();
                    break;
                }
                this.flushPendingErrors();
            }
            finally {
                if (!this.listOfErrors.isEmpty()) {
                    if (marker == null) {
                        marker = this.listOfErrors.get(this.listOfErrors.size() - 1);
                    }
                    this.listOfErrors.clear();
                }
            }
        }
        if (parsers.isEmpty()) {
            this.flushPendingErrors();
        } else if (sizeBeforeCycle == 1 && this.listOfErrorMsgLines.size() == sizeBeforeCycle) {
            this.flushPendingErrorParserErrors();
        }
        if (this.listOfErrorMsgLines.isEmpty()) {
            this.outputLine(line, marker);
        } else {
            this.outputPendingErrorMessages(marker);
        }
        return false;
    }

    private void outputLine(String line, ProblemMarkerInfo marker) {
        this.outputLineQueue.setDone(line, marker);
        this.outputDoneLines();
    }

    private void outputDoneLines() {
        OutputLine line;
        while ((line = this.outputLineQueue.pollDone()) != null) {
            this.outputToConsole(line.getLine(), line.getInfo());
        }
    }

    private void outputToConsole(String line, ProblemMarkerInfo marker) {
        String l = String.valueOf(line) + "\n";
        if (this.outputStream == null) {
            return;
        }
        try {
            if (marker != null && this.outputStream instanceof IErrorMarkeredOutputStream) {
                IErrorMarkeredOutputStream s = (IErrorMarkeredOutputStream)this.outputStream;
                s.write(l, marker);
            } else {
                byte[] b = l.getBytes(Charset.defaultCharset());
                this.outputStream.write(b, 0, b.length);
            }
        }
        catch (IOException e) {
            CCorePlugin.log((Throwable)e);
        }
    }

    public void addErrorMsgLine(String line) {
        this.listOfErrorMsgLines.add(line);
    }

    public void setErrorMsgComplete(boolean isComplete) {
        this.isErrorMsgComplete = isComplete;
    }

    public int getLineCounter() {
        return this.lineCounter;
    }

    public IFile findFileName(String partialLocation) {
        if (partialLocation.equals(this.cachedFileName) && this.cachedWorkingDirectory != null && URIUtil.equals((URI)this.getWorkingDirectoryURI(), (URI)this.cachedWorkingDirectory)) {
            return this.cachedFile;
        }
        char windowsSeparator = '\\';
        Path path = new Path(partialLocation.replace(windowsSeparator, '/'));
        IFile fileInWorkcpace = this.findFileInWorkspace((IPath)path);
        fileInWorkcpace = this.findeFile(partialLocation, (IPath)path, fileInWorkcpace);
        this.cachedFileName = partialLocation;
        this.cachedWorkingDirectory = this.getWorkingDirectoryURI();
        this.cachedFile = fileInWorkcpace;
        return fileInWorkcpace;
    }

    private IFile findeFile(String partialLocation, IPath path, IFile fileInWorkcpace) {
        if (fileInWorkcpace == null) {
            IProject[] projects;
            int emptyFiles = 0;
            int oneFile = 1;
            path = path.setDevice(null);
            IFile[] filesArray = null;
            if (this.project != null && (filesArray = ResourceLookup.findFilesByName((IPath)path, (IProject[])(projects = new IProject[]{this.project}), (boolean)false)).length == emptyFiles) {
                filesArray = ResourceLookup.findFilesByName((IPath)path, (IProject[])projects, (boolean)true);
            }
            if ((filesArray == null || filesArray.length == emptyFiles) && (filesArray = ResourceLookup.findFilesByName((IPath)path, (IProject[])(projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()), (boolean)false)).length == emptyFiles) {
                filesArray = ResourceLookup.findFilesByName((IPath)path, (IProject[])projects, (boolean)true);
            }
            if (filesArray.length == oneFile) {
                fileInWorkcpace = filesArray[0];
            }
        }
        if (fileInWorkcpace == null && isCygwin && path.isAbsolute()) {
            fileInWorkcpace = this.findCygwinFile(partialLocation);
        }
        return fileInWorkcpace;
    }

    protected IFile findFileInWorkspace(IPath path) {
        URI uri;
        if (path.isAbsolute()) {
            uri = this.toURI(path);
            if (uri == null) {
                return null;
            }
        } else {
            URI workingDirectoryURI = this.getWorkingDirectoryURI();
            uri = EFSExtensionManager.getDefault().append(workingDirectoryURI, path.toString());
        }
        return this.findFileInWorkspace(uri);
    }

    protected IFile findFileInWorkspace(URI uri) {
        IFile result = null;
        if (!uri.isAbsolute()) {
            uri = org.eclipse.core.runtime.URIUtil.makeAbsolute((URI)uri, (URI)this.getWorkingDirectoryURI());
        }
        if ((result = ResourceLookup.selectFileForLocationURI((URI)uri, (IProject)this.project)) != null && result.isAccessible()) {
            return result;
        }
        return result;
    }

    @Deprecated
    public boolean isConflictingName(String fileName) {
        Path path = new Path(fileName);
        IProject[] iProjects = new IProject[]{this.project};
        return ResourceLookup.findFilesByName((IPath)path, (IProject[])iProjects, (boolean)false).length > 1;
    }

    @Deprecated
    public IFile findFilePath(String filePath) {
        boolean isCygPath;
        Path path = new Path(filePath);
        IFile file = this.findFileInWorkspace((IPath)path);
        boolean bl = isCygPath = file == null && isCygwin;
        if (isCygPath) {
            file = this.findCygwinFile(filePath);
        }
        return file != null && file.exists() ? file : null;
    }

    private IFile findCygwinFile(String filePath) {
        try {
            return this.findFileInWorkspace((IPath)new Path(Cygwin.cygwinToWindowsPath((String)filePath)));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            isCygwin = false;
        }
        catch (Exception e) {
            CCorePlugin.log((Throwable)e);
        }
        return null;
    }

    public void generateMarker(IResource file, int lineNumber, String desc, int severity, String varName) {
        this.generateExternalMarker(file, lineNumber, desc, severity, varName, null);
    }

    private void outputPendingErrorMessages(ProblemMarkerInfo marker) {
        if (this.isErrorMsgComplete) {
            Iterator<String> iter = this.listOfErrorMsgLines.iterator();
            while (iter.hasNext()) {
                this.outputLine(iter.next(), marker);
            }
            this.listOfErrorMsgLines.clear();
            this.isErrorMsgComplete = false;
        }
    }

    public void generateExternalMarker(IResource file, int lineNumber, String desc, int severity, String varName, IPath externalPath) {
        if (file == null) {
            file = this.project;
        }
        if (externalPath != null && !externalPath.toFile().exists()) {
            ICompilationPathResolver[] iCompilationPathResolverArray = this.resolvers;
            int n = this.resolvers.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationPathResolver resolver = iCompilationPathResolverArray[n2];
                IPath path = resolver.resolve(externalPath, this.project);
                if (path != null && path.toFile().exists()) {
                    externalPath = path;
                    break;
                }
                ++n2;
            }
        }
        ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo(file, lineNumber, desc, severity, varName, externalPath);
        this.outputPendingErrorMessages(problemMarkerInfo);
        this.listOfPendingErrors.add(problemMarkerInfo);
    }

    public void addProblemMarker(ProblemMarkerInfo problemMarkerInfo) {
        this.listOfPendingErrors.add(problemMarkerInfo);
    }

    public void flushPendingErrors() {
        int i = 0;
        while (i < this.listOfPendingErrors.size()) {
            ProblemMarkerInfo problemMarkerInfo = this.listOfPendingErrors.get(i);
            this.listOfErrors.add(problemMarkerInfo);
            this.markerGenerator.addMarker(problemMarkerInfo);
            if (problemMarkerInfo.severity == 2) {
                this.hasErrors = true;
            }
            if (this.listOfErrorMsgLines.size() > 0) {
                this.outputLine(this.listOfErrorMsgLines.remove(0), problemMarkerInfo);
            }
            ++i;
        }
        this.listOfPendingErrors.clear();
    }

    private void flushPendingErrorParserErrors() {
        for (IErrorParser parser : this.collectionsOfErrorParsers) {
            if (parser instanceof IFSLErrorParser3) {
                ((IFSLErrorParser3)parser).flush(this);
                continue;
            }
            if (!(parser instanceof ErrorParserNamedWrapper) || !(((ErrorParserNamedWrapper)parser).getErrorParser() instanceof IFSLErrorParser3)) continue;
            ((IFSLErrorParser3)((ErrorParserNamedWrapper)parser).getErrorParser()).flush(this);
        }
        this.flushPendingErrors();
    }

    public String getPreviousLine() {
        String original = this.previousLine == null ? EMPTY_STRING : this.previousLine;
        return original;
    }

    public void setOutputStream(OutputStream osOutputStream) {
        this.outputStream = osOutputStream;
    }

    public OutputStream getOutputStream() {
        ++this.numberOpens;
        return this;
    }

    public synchronized void close() throws IOException {
        if (this.previousErrorParser instanceof IFSLErrorParser3) {
            ((IFSLErrorParser3)this.previousErrorParser).flush(this);
            this.previousErrorParser = null;
        }
        this.flushPendingErrors();
        if (this.numberOpens > 0 && --this.numberOpens == 0) {
            this.checkLine(true);
            this.directoryStack.clear();
        }
        this.outputLineQueue.setAllDone();
        this.outputDoneLines();
    }

    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public synchronized void write(int b) throws IOException {
        char charFromString = (char)b;
        this.currentLine.append(charFromString);
        this.checkLine(false);
    }

    public synchronized void write(byte[] bytes, int off, int len) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (off != 0 || len < 0 || len > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        String str = new String(bytes, 0, len);
        this.currentLine.append(str);
        this.checkLine(false);
    }

    private void checkLine(boolean flush) {
        String buffer = this.currentLine.toString();
        int i = 0;
        while ((i = buffer.indexOf(10)) != -1) {
            String suffix;
            String line = buffer.substring(0, i);
            if (line.endsWith(suffix = "\r")) {
                line = line.substring(0, line.length() - 1);
            }
            if (!line.equals(this.previousLine)) {
                this.processLine(line);
            } else {
                this.registerOutputLine(line, true);
                this.outputLine(line, null);
            }
            this.previousLine = line;
            buffer = buffer.substring(i + 1);
        }
        this.currentLine.setLength(0);
        if (flush) {
            if (buffer.length() > 0) {
                this.processLine(buffer);
                this.previousLine = buffer;
            }
        } else {
            this.currentLine.append(buffer);
        }
    }

    @Deprecated
    public boolean reportProblems() {
        return false;
    }

    private URI toURI(IPath path) {
        boolean isCorrectPath;
        URI baseURI = this.getWorkingDirectoryURI();
        String uriString = path.toString();
        boolean bl = isCorrectPath = path.isAbsolute() && uriString.charAt(0) != '/';
        if (isCorrectPath) {
            uriString = String.valueOf('/') + uriString;
        }
        return EFSExtensionManager.getDefault().createNewURIFromPath(baseURI, uriString);
    }

    @Deprecated
    public String getScratchBuffer() {
        return this.scratchBuffer.toString();
    }

    @Deprecated
    public void appendToScratchBuffer(String newLine) {
        this.scratchBuffer.append(newLine);
    }

    @Deprecated
    public void clearScratchBuffer() {
        this.scratchBuffer.setLength(0);
    }

    @Deprecated
    public boolean hasErrors() {
        return this.hasErrors;
    }

    public static String[] getUserDefinedErrorParserIds() {
        return FSLErrorParserExtensionManager.getUserDefinedErrorParserIds();
    }

    public static void setUserDefinedErrorParsers(IErrorParserNamed[] errorParsers) throws CoreException {
        FSLErrorParserExtensionManager.setUserDefinedErrorParsers(errorParsers);
    }

    public static String[] getErrorParserAvailableIds() {
        return FSLErrorParserExtensionManager.getErrorParserAvailableIds();
    }

    public static String[] getErrorParserAvailableIdsInContext(String context) {
        return FSLErrorParserExtensionManager.getErrorParserAvailableIdsInContext(context);
    }

    public static String[] getErrorParserExtensionIds() {
        return FSLErrorParserExtensionManager.getErrorParserExtensionIds();
    }

    public static void setDefaultErrorParserIds(String[] iDs) throws BackingStoreException {
        FSLErrorParserExtensionManager.setDefaultErrorParserIds(iDs);
    }

    public static String[] getDefaultErrorParserIds() {
        return FSLErrorParserExtensionManager.getDefaultErrorParserIds();
    }

    public static IErrorParserNamed getErrorParserCopy(String id) {
        return FSLErrorParserExtensionManager.getErrorParserCopy(id, false);
    }

    public static IErrorParserNamed getErrorParserExtensionCopy(String id) {
        return FSLErrorParserExtensionManager.getErrorParserCopy(id, true);
    }

    public static String toDelimitedString(String[] iDs) {
        String result = EMPTY_STRING;
        String[] stringArray = iDs;
        int n = iDs.length;
        int n2 = 0;
        while (n2 < n) {
            String iD = stringArray[n2];
            result = result.length() == 0 ? iD : String.valueOf(result) + ';' + iD;
            ++n2;
        }
        return result;
    }

    public void shutdown() {
        for (IErrorParser parser : this.collectionsOfErrorParsers) {
            if (parser instanceof IErrorParser3) {
                ((IErrorParser3)parser).shutdown();
                continue;
            }
            if (!(parser instanceof ErrorParserNamedWrapper) || !(((ErrorParserNamedWrapper)parser).getErrorParser() instanceof IErrorParser3)) continue;
            ((IErrorParser3)((ErrorParserNamedWrapper)parser).getErrorParser()).shutdown();
        }
        this.flushPendingErrors();
    }

    public IErrorParser getPreviousErrorParser() {
        return this.previousErrorParser;
    }

    public void resetPreviousErrorParser() {
        this.previousErrorParser = null;
    }

    protected IMarkerGenerator getMarkerGenerator() {
        return this.markerGenerator;
    }
}

