/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.property;

import com.nxp.s32ds.cle.runtime.migration.property.MigrationProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MigrationProperties {
    protected static final String PREFIX = "    ";
    private final List<MigrationProperty> properties;

    public MigrationProperties(List<MigrationProperty> properties) {
        this.properties = properties;
    }

    public MigrationProperty getProperty(String name) {
        return this.getProperties(name).stream().findFirst().orElse(null);
    }

    public boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    public String getPropertyValue(String name) {
        return this.getProperties(name).stream().findFirst().map(p -> p.getValue()).orElse(null);
    }

    public List<MigrationProperty> getProperties(String name) {
        return this.properties.stream().filter(p -> name.equals(p.getName())).collect(Collectors.toList());
    }

    public List<String> getPropertyValues(String name) {
        return this.getProperties(name).stream().map(p -> p.getValue()).collect(Collectors.toList());
    }

    public List<MigrationProperty> getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        return this.properties.isEmpty() ? "" : String.valueOf(prefix) + "<properties>\n" + MigrationProperties.toString(PREFIX + prefix, this.properties) + prefix + "</properties>";
    }

    protected static String toString(String prefix, List<MigrationProperty> properties) {
        StringBuilder builder = new StringBuilder();
        for (MigrationProperty property : properties) {
            builder.append(property.toString(prefix)).append("\n");
        }
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MigrationProperties)) {
            return false;
        }
        MigrationProperties other = (MigrationProperties)obj;
        return Objects.equals(this.properties, other.properties);
    }
}

