/* Copyright 2017-2019 NXP */
/* License: BSD 3-clause
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the
       names of its contributors may be used to endorse or promote products
       derived from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * main implementation: use this 'C++' sample to create your own application
 *
 */
 
class CCounter {
private:
	static const int m_limit = 1000000;
	int m_counter;

public:
	CCounter() : m_counter(0) {
	};
	CCounter(const CCounter& counter) {
		m_counter = counter.m_counter;
	}
	void increment() {
		m_counter++;
	};
	int get() {
		return m_counter;
	};
	void set(int value) {
		m_counter = value;
	};
	int getLimit() {
		return m_limit;
	};
};

CCounter* myCounter;
CCounter myAccumulator;

int main() {

	for (;;) {
		myCounter = new CCounter();
		while((myCounter->get() < myCounter->getLimit())) {
			myCounter->increment();
		}
		__asm volatile ("svc 0");
		delete myCounter;
	}

	return 0;
}

extern "C" {

	void Current_EL3_SPx_Sync() {
		myAccumulator.set(myAccumulator.get() + myCounter->get());
	}

}
