/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package com.freescale.system.browser.epl;

import com.freescale.system.browser.epl.TabDescriptorEpl;


/**
 * A listener interested in tab selection events that occur for the tabbed
 * sheet page.
 * 
 * @author Anthony Hunter
 * @version 1.0
 */
public interface ITabSelectionListenerEpl {

	/**
	 * Notifies this listener that the selected tab has changed.
	 * 
	 * @param tabDescriptor
	 *            the selected tab descriptor.
	 */
	public void tabSelected(TabDescriptorEpl tabDescriptor);
}
