/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package com.freescale.system.browser.epl;

import java.util.List;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.freescale.system.browser.epl.ITabDescriptorEpl;


/**
 * The content provider for a tab chooser (TabList)
 */
public class TabListContentProviderEpl
		implements IStructuredContentProvider {
	
	/**
	 * The system contributor who's page is active in the view
	 */
	private SystemContributorEpl fSystemContributor;

	/**
	 * Constructor for TabListContentProvider.
	 */
	public TabListContentProviderEpl(SystemContributorEpl systemContributor) {
		fSystemContributor = systemContributor;
	}
	
	/**
	 * Returns the tabs that are relevant for the give input (active debug context)
	 * 
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	@Override
	public Object[] getElements(Object input) {
		List<ITabDescriptorEpl> list = fSystemContributor.getTabDescriptors(input);
		return list.toArray(new ITabDescriptorEpl[list.size()]);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	@Override
	public void dispose() {//
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	@Override
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {//
		// nothing to do...for now
	}
}
