/*******************************************************************************
 Copyright 2023 NXP 

 NXP Confidential and Proprietary. This software is owned or controlled by NXP
 and may only be used strictly in accordance with the applicable license terms.
 By expressly accepting such terms or by downloading, installing, activating
 and/or otherwise using the software, you are agreeing that you have read, and
 that you agree to comply with and are bound by, such license terms. If you do
 not agree to be bound by the applicable license terms, then you may not retain,
 install, activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.system.browser.epl.help;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import com.freescale.system.browser.epl.ISectionDescriptorEpl;
import com.freescale.system.browser2.Messages2;
import com.freescale.system.browser2.SystemBrowserActivator2;
import com.freescale.system.browser.epl.ISectionDescriptorEpl;
import com.ibm.icu.text.MessageFormat;

public abstract class SectionDescriptorEpl implements ISectionDescriptorEpl{
	private final static String SECTION_ERROR = Messages2.SectionDescriptor_Section_error;
	protected final static String ATT_ID = "id"; //$NON-NLS-1$
	protected final static String ATT_TARGET_TAB = "tab"; //$NON-NLS-1$
	
	/**
	 * The section's ID as described in the extension XML.
	 */
	private final String fId;

	/**
	 * A section descriptor references a single tab descriptor that houses it.
	 * This correlation is specified in the extension (XML)
	 */
	private String fTargetTab;
	
	/**
	 * The extension element (XML) that describes the section.
	 */
	private final IConfigurationElement fConfigurationElement;
		
	protected SectionDescriptorEpl(final IConfigurationElement configurationElement) {
		fId = configurationElement.getAttribute(ATT_ID);
		fTargetTab = configurationElement.getAttribute(ATT_TARGET_TAB);
		fConfigurationElement = configurationElement;
	}
	
	/**
	 *  
	 * */
	protected SectionDescriptorEpl(final IConfigurationElement configurationElement, final String string) {
		this(configurationElement);
		fTargetTab = string;
	}

	public final IConfigurationElement getConfigurationElement() {
		return fConfigurationElement;
	}
	
	@Override
	public final String getId() {
		return fId;
	}

	@Override
	public final String getTargetTab() {		
		return fTargetTab;
	}
	
	/**
	 * Handle the section error when an issue is found loading from the
	 * configuration element.
	 * 
	 * @param configurationElement
	 *            the configuration element
	 * @param exception
	 *            an optional CoreException
	 */
	protected void handleSectionError(CoreException exception) {
		String pluginId = getConfigurationElement().getDeclaringExtension().getNamespaceIdentifier();
		String message = MessageFormat.format(SECTION_ERROR, new Object[] { pluginId});
		IStatus status = new Status(IStatus.ERROR, pluginId, 0, message, exception);

		SystemBrowserActivator2.log(status);
	}
}
