/*******************************************************************************
 Copyright 2023 NXP 

 NXP Confidential and Proprietary. This software is owned or controlled by NXP
 and may only be used strictly in accordance with the applicable license terms.
 By expressly accepting such terms or by downloading, installing, activating
 and/or otherwise using the software, you are agreeing that you have read, and
 that you agree to comply with and are bound by, such license terms. If you do
 not agree to be bound by the applicable license terms, then you may not retain,
 install, activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.system.browser.epl.help;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import com.freescale.system.browser2.ISimpleTableDataProvider2;

public class SimpleTableDataDescriptorEpl extends SectionDescriptorEpl {
	
	private static final String ATT_CLASS = "class"; //$NON-NLS-1$
	
	public SimpleTableDataDescriptorEpl(IConfigurationElement configurationElement) {
		super(configurationElement, TasksTabDescriptorEpl.class.toString());
		if (getId() == null || getTargetTab() == null) {
			// the section id and tab are mandatory - log error
			handleSectionError(null);
		}
	}

	public final ISimpleTableDataProvider2 createDataProvider() {
		ISimpleTableDataProvider2 section = null;

		try {
			section = (ISimpleTableDataProvider2)getConfigurationElement().createExecutableExtension(ATT_CLASS);
		} catch (CoreException exception) {
			handleSectionError(exception);
		}

		return section;
	}
}
