/*******************************************************************************
 Copyright 2023 NXP 

 NXP Confidential and Proprietary. This software is owned or controlled by NXP
 and may only be used strictly in accordance with the applicable license terms.
 By expressly accepting such terms or by downloading, installing, activating
 and/or otherwise using the software, you are agreeing that you have read, and
 that you agree to comply with and are bound by, such license terms. If you do
 not agree to be bound by the applicable license terms, then you may not retain,
 install, activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.system.browser.epl.help;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

import com.freescale.system.browser.epl.help.TasksTabDescriptorEpl.Column;

public class TasksTreeComparatorEpl extends ViewerComparator {	
	/**
	 * The sort column index. I.e., when the user clicks a column to sort the
	 * table, the index of that column is set here.
	 */
	private int fSortColumn;	
	/**
	 * Constructor
	 * 
	 * @param columns the collection of columns present in the table
	 */
	TasksTreeComparatorEpl(Column[] columns) {
	}
	
	/**
	 * Accessor method. See fSortColumn
	 */
	void setSortColumn(int index) {
		assert(index >= 0);
		if (index >= 0) {
			fSortColumn = index;
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ViewerComparator#compare(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	@Override
	public int compare(Viewer viewer, Object e1, Object e2) {
		return fSortColumn;
	}
}
