/*******************************************************************************
 * Copyright 2023 NXP
 * 
 * SPDX-License-Identifier: EPL-1.0
 *******************************************************************************/

package com.nxp.sa.v8.launch.ui.epl;

import java.util.HashSet;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.DebugPlugin;

import com.freescale.sa.util.Logger;
import com.freescale.sa.util.LoggerStatus;


public class Activator extends AbstractUIPlugin {

	private static Logger LOGGER;
	// The shared instance
	private static Activator plugin;
	
	// The plug-in ID
	public static final String PLUGIN_ID = "com.nxp.sa.v8.launch.ui.epl"; 
	private static final String HARDWARE_LAUNCH_TYPE = "org.eclipse.cdt.debug.gdbjtag.launchConfigurationType";
	private static final String PREFERRED_SA_HARDWARE_LAUNCH_DELEGATE = "com.freescale.sa.ls.v8.launch.ui.CodeWarriorLaunchDelegate";

	public Activator() {}
	
	public Logger getLogger() {
		return LOGGER;
	}

	public void start(BundleContext context) throws Exception {
		super.start(context);
		LOGGER = Logger.getLogger(context.getBundle());
		plugin = this;
		setDefaultLaunchDelegates();
	}

	public void stop(BundleContext context) throws Exception {
		plugin = null;
		LOGGER = null;
		super.stop(context);
	}
	
	public static Activator getDefault() {
		return plugin;
	}

	public void logError(String msg) {
		LoggerStatus status = getLogger().getErrorStatus(msg);
		getLogger().log(status);
	}
	
	private void setDefaultLaunchDelegates() {
		ILaunchManager launchMgr = DebugPlugin.getDefault().getLaunchManager();

		HashSet<String> debugSet = new HashSet<String>();
		debugSet.add(ILaunchManager.DEBUG_MODE);

		ILaunchConfigurationType remoteCfg = launchMgr.getLaunchConfigurationType(HARDWARE_LAUNCH_TYPE);
		try {
			ILaunchDelegate[] delegates = remoteCfg.getDelegates(debugSet);
			for (ILaunchDelegate delegate : delegates) {
				if (PREFERRED_SA_HARDWARE_LAUNCH_DELEGATE.equals(delegate.getId())) {
					remoteCfg.setPreferredDelegate(debugSet, delegate);
					break;
				}
			}
			
		} catch (CoreException e) {}
	}
}
