/*******************************************************************************
 * Copyright 2023 NXP
 * NXP Confidential and Proprietary. This software is owned or controlled by NXP and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.system.browser2;

import org.eclipse.ui.IActionBars;


/**
 * Allows a systemContributor to customize the System Browser view
 * action bars. A contributor should use this interface
 * to add actions that apply to its page as a whole. Actions specific to
 * sections (within tabs) should be contributed via {@link ISection#setActionBarsForTab(IActionBars)}
 */
public interface IActionProvider2 {

	/**
	 * Called whenever a tab is about to be shown, not just when the systemContributor's
	 * page is. Reason for this frequency is that the action bars are customized on each
	 * change in tab selection. The toolbar, for example, is automatically cleared and rebuilt.
	 * So, although the IActionProvider typically provides toolbar actions that appear in all
	 * tabs of its page, it has to be asked to add them one each tab change.  
	 * 
	 * @param actionBars
	 *            the action bars for the page
	 */
	public void setActionBars(IActionBars actionBars);
}
