/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.registry;

import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import com.nxp.s32ds.ext.rcp.registry.ReferenceDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ElementDescriptor
implements EntityDescriptor,
ReferenceDescriptor {
    public static final String KEY_ID = "id";
    public static final String KEY_NAME = "name";
    public static final String KEY_DESCRIPTION = "description";
    public static final String KEY_SOURCE_ID = "sourceId";
    public static final String KEY_TARGET_ID = "targetId";
    public static final String KEY_CLASS = "class";
    public static final String ATTRIBUTE_VALUES_SEPARATOR = ",";
    private final Element element;
    private final Map<String, String> attributeNames = new HashMap<String, String>();

    public ElementDescriptor(Element element) {
        this.element = element;
    }

    public void addSubstitution(String key, String value) {
        this.attributeNames.put(key, value);
    }

    public String getAttribute(String attributeName) {
        String substitution = this.attributeNames.get(attributeName);
        if (substitution == null) {
            substitution = attributeName;
        }
        return this.element.getAttribute(substitution);
    }

    public Set<String> getAttributesSet(String attributeName) {
        return Arrays.stream(this.getAttribute(attributeName).split(ATTRIBUTE_VALUES_SEPARATOR)).map(String::trim).filter(attribute -> !attribute.isEmpty()).collect(Collectors.toSet());
    }

    @Override
    public String getId() {
        return this.getAttribute(KEY_ID);
    }

    @Override
    public String getName() {
        return this.getAttribute(KEY_NAME);
    }

    @Override
    public String getDescription() {
        return this.getAttribute(KEY_DESCRIPTION);
    }

    @Override
    public String getSourceId() {
        return this.getAttribute(KEY_SOURCE_ID);
    }

    @Override
    public String getTargetId() {
        return this.getAttribute(KEY_TARGET_ID);
    }
}

