/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.ddr.importer;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.ddr.controller.DDRController;
import com.nxp.swtools.ddr.controller.DDRControllerWrapper;
import com.nxp.swtools.ddr.model.DDRDataModel;
import com.nxp.swtools.mem.validation.integration.ddr.MemValDDRServiceProvider;
import com.nxp.swtools.mem.validation.utils.StringUtils;
import com.nxp.swtools.mem.validation.views.ValidationView;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.IQuickSetting;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.utils.events.ToolEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.ISourceProviderService;

public class RPAImportedData {
    private static final Logger LOGGER = LogManager.getLogger(RPAImportedData.class);
    public static final String DS_DDR_DRAM_CMD_PARAMETER = "ddrparam";
    public static final String DS_DDR_SYS_CMD_PARAMETER = "sysparam";
    public static final String DS_DDR_DRAM_TYPE_PARAMETER = "dram_type";
    public static final String DS_DDR_LPDDR4_TYPE_PARAMETER = "lp4x_mode";
    public static final String DS_DDR_FW_VERSION_PARAMETER = "fw_version";
    public static final String MEM_TYPE_PARAMETER = "deviceInformation.memoryType";
    public static final String DDR_MEM_TYPE_PARAMETER = "DDRC.DDRC.deviceInformation.memoryType";
    public static final String PHY_FW_VERSION_PARAMETER = "DDRC.DDRC.phyOptions.firmware_versions";
    private static final String DS_FILE_NAME = "ddr_config.ds";
    private Map<String, ScalarConfig> ddrParameters = new HashMap<String, ScalarConfig>();
    private StringBuilder text = new StringBuilder();
    private String memType = "";
    private String fwVersion = "";

    public void clean() {
        this.text.setLength(0);
    }

    private RPAImportedData() {
        IComponentInstanceConfig currentComponent = RPAImportedData.getCurrentDDRConfiguration();
        if (currentComponent != null) {
            RPAImportedData.getChildParameters((IChild)currentComponent, "", this.ddrParameters);
        }
        ISharedConfiguration sharedConfiguration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        sharedConfiguration.addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

            public void configurationChanged(ISharedConfiguration sharedConfiguration, IConfigChangeContext changeContext) {
                RPAImportedData.updateServiceProvider();
            }

            public void configurationReloaded(ISharedConfiguration sharedConfiguration, ConfigChangeReason reason) {
                RPAImportedData.updateServiceProvider();
            }
        });
    }

    public static RPAImportedData getInstance() {
        try {
            return (RPAImportedData)SWTFactoryProxy.INSTANCE.getSingletonInstance(RPAImportedData.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain user-singleton instance of: " + RPAImportedData.class.getSimpleName(), e);
        }
    }

    public boolean loadDataFromFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            LOGGER.log(Level.SEVERE, "[RPADescriptor] Unable to locate RPA file {0}!", filePath);
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (Stream<String> stream = Files.lines(file.toPath());){
                Object[] objectArray = stream.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object lineObj = objectArray[n2];
                    if (lineObj instanceof String) {
                        int lpddr4Mode;
                        String lineStr = (String)lineObj;
                        lineStr = lineStr.replace("\t", " ");
                        this.text.append(String.valueOf(lineStr) + "\r\n");
                        if (lineStr.startsWith(DS_DDR_DRAM_CMD_PARAMETER) && lineStr.contains(DS_DDR_DRAM_TYPE_PARAMETER)) {
                            this.memType = this.getImportedDRAMType(lineStr.split("\\s+")[3]);
                        }
                        if (this.memType.equals("LPDDR4") && lineStr.startsWith(DS_DDR_DRAM_CMD_PARAMETER) && lineStr.contains(DS_DDR_LPDDR4_TYPE_PARAMETER) && (lpddr4Mode = Integer.parseInt(StringUtils.parseAsNumber((String)lineStr.split("\\s+")[3]))) == 1) {
                            this.memType = "LPDDR4x";
                        }
                        if (lineStr.startsWith(DS_DDR_SYS_CMD_PARAMETER) && lineStr.contains(DS_DDR_FW_VERSION_PARAMETER)) {
                            this.fwVersion = this.getImportedFWVersion(lineStr.split("\\s+")[3]);
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.severe(String.format("[RPADescriptor] Unable to get RPA data from file (%s)!", e.getMessage()));
            return false;
        }
        catch (NumberFormatException e) {
            LOGGER.severe(String.format("[RPADescriptor] RPA file not in expected format (%s)!", e.getMessage()));
            return false;
        }
        return true;
    }

    public static @Nullable IComponentInstanceConfig getCurrentDDRConfiguration() {
        DDRController ddrController = DDRController.getInstance();
        DDRDataModel ddrDataModel = ddrController.getDataModel();
        CollectionsUtils.Pair currentComponent = ddrDataModel.getCurrentComponent();
        if (currentComponent != null) {
            return (IComponentInstanceConfig)currentComponent.getSecond();
        }
        return null;
    }

    private static void getChildParameters(IChild config, String name, Map<String, ScalarConfig> parameters) {
        if (config instanceof ScalarConfig) {
            parameters.put(String.valueOf(name) + config.getName(), (ScalarConfig)config);
        } else if (config instanceof IChildProvidable) {
            IChildProvidable childProvidable = (IChildProvidable)config;
            for (IChild child : childProvidable.getChildren()) {
                RPAImportedData.getChildParameters(child, String.valueOf(name) + childProvidable.getName() + ".", parameters);
            }
        }
    }

    public Map<String, ScalarConfig> getDDRParameters() {
        return this.ddrParameters;
    }

    protected String getImportedDRAMType(String dramTypeId) {
        List setting;
        Optional<SetSetting.Item> item;
        ScalarConfig structTypeItem = this.ddrParameters.get(DDR_MEM_TYPE_PARAMETER);
        String dramTypeItem = null;
        if (structTypeItem != null && (item = (setting = structTypeItem.getEnumItems()).stream().filter(x -> x.getValue().equals(dramTypeId)).findAny()).isPresent()) {
            dramTypeItem = item.get().getId();
        }
        if (dramTypeItem != null) {
            return dramTypeItem;
        }
        return "UNKNOWN";
    }

    protected String getImportedFWVersion(String fwVersionId) {
        List setting;
        Optional<SetSetting.Item> item;
        ScalarConfig structTypeItem = this.ddrParameters.get(PHY_FW_VERSION_PARAMETER);
        String fwVersionItem = null;
        if (structTypeItem != null && (item = (setting = structTypeItem.getEnumItems()).stream().filter(x -> x.getValue().equals(fwVersionId)).findAny()).isPresent()) {
            fwVersionItem = item.get().getId();
        }
        if (fwVersionItem != null) {
            return fwVersionItem;
        }
        return "";
    }

    protected @Nullable IQuickSelection findQuickSelection(IConfigSetConfig configSet, String id, String value) {
        IQuickSelection quickSelection = null;
        String settingValue = null;
        List quickSelections = configSet.getQuickSelectionGroup().getQuickSelections();
        for (IQuickSelection qSelection : quickSelections) {
            IQuickSetting settingId = qSelection.getSetting(id);
            if (settingId == null) continue;
            settingValue = settingId.getValue();
            assert (settingValue != null);
            if (!settingValue.equals(value)) continue;
            quickSelection = qSelection;
            break;
        }
        return quickSelection;
    }

    void saveDsFile() {
        File tmpDir = UtilsFile.createTempSubDirectory((String)"mem_validation");
        String logsFolder = tmpDir.getAbsolutePath();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(logsFolder) + File.separator + DS_FILE_NAME), StandardCharsets.UTF_8));){
                writer.write(this.text.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.warning(e.getMessage());
        }
    }

    public void apply() {
        IComponentInstanceConfig compInstance;
        ScalarConfig structTypeItem;
        IQuickSelection quickSelection;
        IConfigSetConfig configSet = DDRController.getInstance().getDataModel().getCurrentConfigSet();
        if (configSet != null && (quickSelection = this.findQuickSelection(configSet, MEM_TYPE_PARAMETER, this.getMemType())) != null) {
            configSet.setQuickSelection(quickSelection);
            configSet.applySelectedQuickSelection();
        }
        if (!this.fwVersion.isEmpty() && (structTypeItem = this.ddrParameters.get(PHY_FW_VERSION_PARAMETER)) != null) {
            structTypeItem.setValue(this.fwVersion);
        }
        if ((compInstance = RPAImportedData.getCurrentDDRConfiguration()) != null) {
            compInstance.setEditingLockState(true);
        }
        APeriphController controller = DDRControllerWrapper.getInstance().getController();
        ((DDRController)controller).fireListeners(new ToolEvent.Builder(32).setOriginator((Object)controller).setObject((Object)IChildControl.UpdateType.FORCE_DISABLE).build());
        RPAImportedData.updateServiceProvider();
        RPAImportedData.removeOldTestResults();
    }

    public String getMemType() {
        return this.memType;
    }

    public String getFwVersion() {
        return this.fwVersion;
    }

    public void unlockUI() {
        IComponentInstanceConfig compInstance = RPAImportedData.getCurrentDDRConfiguration();
        if (compInstance != null && compInstance.isEditingLocked()) {
            compInstance.setEditingLockState(false);
            APeriphController controller = DDRControllerWrapper.getInstance().getController();
            ((DDRController)controller).fireListeners(new ToolEvent.Builder(32).setOriginator((Object)controller).setObject((Object)IChildControl.UpdateType.NORMAL).build());
            RPAImportedData.updateServiceProvider();
            RPAImportedData.removeOldTestResults();
        }
    }

    public static void updateServiceProvider() {
        MemValDDRServiceProvider serviceProvider = null;
        @Nullable ISourceProviderService service = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
        if (!Objects.isNull(service)) {
            assert (service != null);
            ISourceProvider provider = service.getSourceProvider("com.nxp.swtools.mem.validation.integration.ddr.isComponentLocked");
            if (provider instanceof MemValDDRServiceProvider) {
                serviceProvider = (MemValDDRServiceProvider)provider;
            }
        }
        if (serviceProvider != null) {
            serviceProvider.updateState();
        }
    }

    private static void removeOldTestResults() {
        File tmpDir = UtilsFile.createTempSubDirectory((String)"mem_validation");
        String logsFolder = tmpDir.getAbsolutePath();
        List fileNames = UtilsFile.findFilesByExtension((String)logsFolder, (String)".log");
        for (String fileName : fileNames) {
            UtilsFile.deleteDirectory((File)UtilsFile.newFile((String)File.separator, (String[])new String[]{fileName}));
        }
        IViewPart validationView = PerspectivesHelper.getViewById((String)"com.nxp.swtools.mem.validation.views.ValidationView", null);
        if (validationView instanceof ValidationView) {
            ((ValidationView)validationView).resetPresentationModel();
        }
    }
}

