/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.server.core;

import com.nxp.s32ds.rcp.collateral.server.core.CollateralContentHandler;
import com.nxp.s32ds.rcp.collateral.server.core.CollateralServerActivator;
import com.nxp.s32ds.rcp.collateral.server.core.CollateralServerSettings;
import com.nxp.s32ds.rcp.collateral.server.core.servlets.PackageServlet;
import com.nxp.s32ds.rcp.collateral.server.core.servlets.PackagesServlet;
import com.nxp.s32ds.rcp.collateral.server.core.servlets.ResourceServlet;
import com.nxp.s32ds.rcp.collateral.server.core.servlets.ResourcesByTagServlet;
import com.nxp.s32ds.rcp.collateral.server.core.servlets.TagsServlet;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class CollateralServerStarterJob
extends Job {
    private static final String PACK = "/pack";
    private static final String RESOURCE_BY_TAG = "/resourceByTag";
    private static final String PACKAGES = "/packages";
    private static final String RESOURCE = "/resource";
    private static final String TAGS = "/tags";
    private static final String ROOT = "/";
    private final Server jettyServer = new Server();
    private static ServerConnector connector;
    public static CollateralServerStarterJob INSTANCE;

    static {
        INSTANCE = new CollateralServerStarterJob();
    }

    public CollateralServerStarterJob() {
        super("Starting Jetty Server");
        connector = new ServerConnector(this.jettyServer);
        connector.setHost("localhost");
        this.jettyServer.addConnector((Connector)connector);
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        Handler resourceContextHndl = this.createResourceContextHandler();
        Handler htmlContextHndl = this.createHtmlContextHandler();
        Handler s32dsContextHndl = this.createS32DSContextHandler();
        Handler servletTagsContextHandler = this.createTagsContextHandler();
        Handler servletPackagesContextHandler = this.createPackagesServletContextHandler();
        Handler packageServletContextHandler = this.createPackageServletContextHandler();
        Handler createResourcesByTagContextHandler = this.createResourcesByTagContextHandler();
        Handler collateralResoueceContextHandler = this.createCollateralResoueceContextHandler();
        handlers.setHandlers(new Handler[]{resourceContextHndl, s32dsContextHndl, htmlContextHndl, servletTagsContextHandler, servletPackagesContextHandler, packageServletContextHandler, collateralResoueceContextHandler, createResourcesByTagContextHandler});
        this.jettyServer.setHandler((Handler)handlers);
    }

    protected IStatus run(IProgressMonitor monitor) {
        return this.startServer();
    }

    private Handler createTagsContextHandler() {
        ServletContextHandler servletContextHandler = new ServletContextHandler(0);
        servletContextHandler.setContextPath(TAGS);
        servletContextHandler.addServlet(new ServletHolder((Servlet)new TagsServlet()), ROOT);
        return servletContextHandler;
    }

    private Handler createCollateralResoueceContextHandler() {
        ServletContextHandler servletContextHandler = new ServletContextHandler(0);
        servletContextHandler.setContextPath(RESOURCE);
        servletContextHandler.addServlet(new ServletHolder((Servlet)new ResourceServlet()), ROOT);
        return servletContextHandler;
    }

    private Handler createPackagesServletContextHandler() {
        ServletContextHandler servletContextHandler = new ServletContextHandler(0);
        servletContextHandler.setContextPath(PACKAGES);
        servletContextHandler.addServlet(new ServletHolder((Servlet)new PackagesServlet()), ROOT);
        return servletContextHandler;
    }

    private Handler createPackageServletContextHandler() {
        ServletContextHandler servletContextHandler = new ServletContextHandler(0);
        servletContextHandler.setContextPath(PACK);
        servletContextHandler.addServlet(new ServletHolder((Servlet)new PackageServlet()), ROOT);
        return servletContextHandler;
    }

    private Handler createResourcesByTagContextHandler() {
        ServletContextHandler servletContextHandler = new ServletContextHandler(0);
        servletContextHandler.setContextPath(RESOURCE_BY_TAG);
        servletContextHandler.addServlet(new ServletHolder((Servlet)new ResourcesByTagServlet()), ROOT);
        return servletContextHandler;
    }

    private IStatus startServer() {
        IStatus returnStatus;
        connector.setPort(CollateralServerSettings.getPort());
        try {
            this.jettyServer.start();
            returnStatus = Status.OK_STATUS;
        }
        catch (Exception e) {
            Status status = new Status(4, "com.nxp.s32ds.rcp.collateral.server", e.getMessage(), (Throwable)e);
            CollateralServerActivator.getInstance().log((IStatus)status);
            returnStatus = status;
        }
        return returnStatus;
    }

    private IStatus stopServer() {
        IStatus returnStatus;
        try {
            this.jettyServer.stop();
            returnStatus = Status.OK_STATUS;
        }
        catch (Exception e) {
            Status status = new Status(4, "com.nxp.s32ds.rcp.collateral.server", e.getMessage(), (Throwable)e);
            CollateralServerActivator.getInstance().log((IStatus)status);
            returnStatus = status;
        }
        return returnStatus;
    }

    public IStatus restartServer() {
        IStatus returnStatus = this.stopServer();
        if (returnStatus.isOK()) {
            returnStatus = this.startServer();
        }
        return returnStatus;
    }

    private Handler createHtmlContextHandler() {
        CollateralContentHandler htmlHandler = new CollateralContentHandler();
        ContextHandler htmlContextHandler = new ContextHandler();
        htmlContextHandler.setContextPath(ROOT);
        htmlContextHandler.setHandler((Handler)htmlHandler);
        return htmlContextHandler;
    }

    private Handler createResourceContextHandler() {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        ContextHandler resourceContextHandler = new ContextHandler();
        resourceContextHandler.setContextPath("/res");
        String resFolder = CollateralServerSettings.getContentPath();
        resourceContextHandler.setResourceBase(resFolder);
        resourceContextHandler.setHandler((Handler)resourceHandler);
        return resourceContextHandler;
    }

    private Handler createS32DSContextHandler() {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        ContextHandler resourceContextHandler = new ContextHandler();
        resourceContextHandler.setContextPath("/S32DS");
        String s32dsFolder = "";
        try {
            Path s32dsPath = Paths.get(Platform.getInstallLocation().getURL().toURI());
            s32dsFolder = String.valueOf(s32dsPath.toAbsolutePath().toString()) + File.separator + ".." + File.separator + "S32DS";
        }
        catch (URISyntaxException e) {
            CollateralServerActivator.getInstance().logError(e.getMessage());
        }
        resourceContextHandler.setResourceBase(s32dsFolder);
        resourceContextHandler.setHandler((Handler)resourceHandler);
        return resourceContextHandler;
    }
}

