/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard;

import com.freescale.s32ds.cross.core.Activator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class EmbSysSettingsUtil {
    public static final String STORAGE = "org.eclipse.embsys";
    public static final String REGISTER_BOARD = "register_board";
    public static final String REGISTER_VENDOR = "register_vendor";
    public static final String REGISTER_CHIP = "register_chip";
    public static final String REGISTER_ARCHITECTURE = "register_architecture";
    public static final String REGISTER_CORE = "register_core";
    public static final String PARENT_PROJECT = "parent_project";
    public static final String BOARD = "---  none ---";
    public static final String EMBSYS_LINGVO_ARCH_TYPE = "embsys.Architecture";
    public static final String EMBSYS_LINGVO_CHIP_TYPE = "embsys.Chip";
    public static final String EMBSYS_LINGVO_CORE_TYPE = "embsys.Core";
    public static final String EMBSYS_LINGVO_ARCH_DEFAULT_S32DS_NAME = "$DEFAULT$";
    private static final String FREESCALE_VENDOR = "Freescale";
    private static final String NXP_VENDOR = "NXP";

    public static void setEmbsysDescriptionData(IProject p, boolean autostart, ICProjectDescription cd) throws CoreException {
        ICSettingEntry[] embsysEntries;
        ICStorageElement embsysStorage = cd.getStorage(STORAGE, true);
        ICSettingEntry[] iCSettingEntryArray = embsysEntries = EmbSysSettingsUtil.createEmbsysEntries(p, autostart);
        int n = embsysEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ICSettingEntry entry = iCSettingEntryArray[n2];
            embsysStorage.setAttribute(entry.getName(), entry.getValue());
            ++n2;
        }
    }

    public static ICSettingEntry[] createEmbsysEntries(IProject project, boolean autostart) {
        ArrayList<CMacroEntry> entries = new ArrayList<CMacroEntry>();
        try {
            Map persistentProperties = project.getPersistentProperties();
            entries.add(CDataUtil.createCMacroEntry((String)REGISTER_ARCHITECTURE, (String)((String)persistentProperties.get(new QualifiedName(REGISTER_ARCHITECTURE, "architecture"))), (int)0));
            entries.add(CDataUtil.createCMacroEntry((String)REGISTER_VENDOR, (String)((String)persistentProperties.get(new QualifiedName(REGISTER_VENDOR, "vendor"))), (int)0));
            entries.add(CDataUtil.createCMacroEntry((String)REGISTER_CHIP, (String)((String)persistentProperties.get(new QualifiedName(REGISTER_CHIP, "chip"))), (int)0));
            entries.add(CDataUtil.createCMacroEntry((String)REGISTER_CORE, (String)((String)persistentProperties.get(new QualifiedName(REGISTER_CORE, "core"))), (int)0));
            entries.add(CDataUtil.createCMacroEntry((String)REGISTER_BOARD, (String)BOARD, (int)0));
            entries.add(CDataUtil.createCMacroEntry((String)PARENT_PROJECT, (String)Boolean.toString(autostart), (int)0));
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
        }
        return entries.toArray(new ICSettingEntry[entries.size()]);
    }

    public static void setEmbsysDescriptionDataExt(String family, String device, String core, ICProjectDescription projectDescription) throws CoreException {
        ICSettingEntry[] entries = new ICSettingEntry[]{CDataUtil.createCMacroEntry((String)REGISTER_ARCHITECTURE, (String)family, (int)0), CDataUtil.createCMacroEntry((String)REGISTER_CHIP, (String)device, (int)0), CDataUtil.createCMacroEntry((String)REGISTER_CORE, (String)core, (int)0)};
        ICStorageElement storage = projectDescription.getStorage(STORAGE, true);
        ICSettingEntry[] iCSettingEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ICSettingEntry entry = iCSettingEntryArray[n2];
            storage.setAttribute(entry.getName(), entry.getValue());
            ++n2;
        }
    }

    public static String getVendor(String deviceName) {
        HashMap<String, String> chipToVendor = new HashMap<String, String>();
        chipToVendor.put("SKEAZ1284", FREESCALE_VENDOR);
        chipToVendor.put("SKEAZN84", FREESCALE_VENDOR);
        chipToVendor.put("SKEAZN642", FREESCALE_VENDOR);
        chipToVendor.put("S32K144", FREESCALE_VENDOR);
        chipToVendor.put("S32K142", FREESCALE_VENDOR);
        chipToVendor.put("S32K146", FREESCALE_VENDOR);
        chipToVendor.put("S32K148", FREESCALE_VENDOR);
        chipToVendor.put("S32V234", FREESCALE_VENDOR);
        chipToVendor.put("S32K116", FREESCALE_VENDOR);
        chipToVendor.put("MAC57D54H", FREESCALE_VENDOR);
        chipToVendor.put("S32G275", NXP_VENDOR);
        chipToVendor.put("S32R45", NXP_VENDOR);
        chipToVendor.put("S32S247", NXP_VENDOR);
        chipToVendor.put("S32V244", NXP_VENDOR);
        String vendor = (String)chipToVendor.get(deviceName);
        if (vendor != FREESCALE_VENDOR && vendor != NXP_VENDOR) {
            vendor = NXP_VENDOR;
        }
        return vendor;
    }
}

