/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page1;

import com.freescale.s32ds.cross.core.model.CdtTemplateInfo;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.wizard.page1.ContentComposite;
import com.freescale.s32ds.cross.wizard.page1.ExtendedPatternFilter;
import com.freescale.s32ds.cross.wizard.page1.FilteredContentProvider;
import com.freescale.s32ds.cross.wizard.page1.FilteredLabelProvider;
import com.freescale.s32ds.cross.wizard.page1.S32DSMultiPageOne;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class FilteredContentComposite
extends ContentComposite {
    private FilteredTree filteredTree;
    private FamilyData defaultFamily;

    public FilteredContentComposite(S32DSMultiPageOne pageManager, boolean executable, Composite parent, int style) {
        super(pageManager, executable, parent, style);
    }

    @Override
    protected Tree createHardwareTree(Composite parent, int style) {
        this.filteredTree = new FilteredTree(parent, style, (PatternFilter)new ExtendedPatternFilter(), true);
        GridDataFactory.fillDefaults().grab(true, true).hint(0, 400).applyTo((Control)this.filteredTree);
        this.filteredTree.getViewer().setContentProvider((IContentProvider)new FilteredContentProvider(this.getContext(), e -> this.hasTemplate((ProcessorData)e)));
        this.filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new FilteredLabelProvider());
        List families = this.getContext().getModel().getFamilies();
        this.defaultFamily = this.findDefaulFamilyData(families);
        this.filteredTree.getViewer().setInput((Object)families);
        this.filteredTree.getViewer().expandAll();
        this.filteredTree.getViewer().addSelectionChangedListener(event -> {
            TreeSelection selection = (TreeSelection)event.getSelection();
            Object source = selection.getFirstElement();
            this.updateContent(source);
        });
        this.createContextMenu(this.filteredTree.getViewer());
        return this.filteredTree.getViewer().getTree();
    }

    @Override
    protected void initContent() {
        if (this.defaultFamily != null) {
            this.filteredTree.getViewer().expandToLevel((Object)this.defaultFamily, 1);
        }
    }

    @Override
    public void select(ConfigurationData data) {
        this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)data), true);
        this.update();
    }

    private FamilyData findDefaulFamilyData(List<FamilyData> families) {
        return families.stream().filter(f -> f.getProcessors().stream().anyMatch(this::hasTemplate)).findFirst().orElse(null);
    }

    private void createContextMenu(TreeViewer viewer) {
        MenuManager contextMenu = new MenuManager("#HardwareMenu");
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(mgr -> this.fillContextMenu(mgr, viewer));
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager menu, final TreeViewer viewer) {
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IAction)new Action("Expand All"){

            public void run() {
                viewer.expandAll();
            }
        });
        menu.add((IAction)new Action("Collapse All"){

            public void run() {
                viewer.collapseAll();
            }
        });
    }

    private boolean hasTemplate(ProcessorData processorData) {
        List coreNatures = processorData.getCoreNatures(this.isExecutable());
        if (coreNatures.isEmpty()) {
            return false;
        }
        for (CoreNatureData coreNature : coreNatures) {
            List cConfigurations = CoreNatureConfiguration.getAll((CoreNatureData)coreNature);
            if (cConfigurations.isEmpty()) continue;
            for (CoreNatureConfiguration cConfiguration : cConfigurations) {
                CdtTemplateInfo toolChainInfo = cConfiguration.getTemplate().getTemplateInfo(this.isExecutable());
                if (toolChainInfo == null) continue;
                String toolChainId = toolChainInfo.getToolChainId();
                IToolChain toolChain = this.getContext().getRegistry().getToolChain(toolChainId);
                if (toolChain == null) continue;
                return true;
            }
        }
        return false;
    }
}

