/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page1;

import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorConfiguration;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import com.freescale.s32ds.cross.wizard.INewProjectLocationSource;
import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSAbstractWizard;
import com.freescale.s32ds.cross.wizard.S32DSMultiProjectWizard;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.WizardArtifactType;
import com.freescale.s32ds.cross.wizard.page1.FilteredContentComposite;
import com.freescale.s32ds.cross.wizard.page1.LocationArea;
import com.freescale.s32ds.cross.wizard.page1.NameListener;
import com.freescale.s32ds.cross.wizard.page1.Page1Utils;
import com.freescale.s32ds.cross.wizard.page2.S32DSMultiPageTwo;
import com.nxp.s32ds.ext.rcp.databinding.ValidationDescriptors;
import com.nxp.s32ds.ext.rcp.databinding.validation.CompositeValidator;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class S32DSMultiPageOne
extends WizardPage
implements INewProjectLocationSource {
    private static final String PAGE_NAME = Messages.S32DSMultiPageOne_page_name;
    private final Map<String, S32DSMultiPageTwo> exepages = new HashMap<String, S32DSMultiPageTwo>();
    private final Map<String, S32DSMultiPageTwo> libpages = new HashMap<String, S32DSMultiPageTwo>();
    Collection<IValidator<String>> nameValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.name.validators");
    Collection<IValidator<String>> pathValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.path.validators");
    Collection<IValidator<String>> nonDefaultPathValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.path.nondefault.location.validators");
    private final CompositeValidator compositeNameValidator = new CompositeValidator(new ArrayList<IValidator<String>>(this.nameValidators));
    private final CompositeValidator compositePathValidator = new CompositeValidator(new ArrayList<IValidator<String>>(this.pathValidators));
    private final CompositeValidator compositeNonDefaultPathValidator = new CompositeValidator(new ArrayList<IValidator<String>>(this.nonDefaultPathValidators));
    private Text projectNameText;
    private final String initProjectName = "";
    private LocationArea locationArea;
    private ProcessorData selectedProcessor;

    public S32DSMultiPageOne(String pageName, S32DSAbstractWizard wizard) {
        super(pageName, "Create a S32 Design Studio Project", null);
        this.setWizard(wizard);
        this.setPageComplete(false);
        wizard.getContext().initData();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public String getProjectBaseName() {
        return this.projectNameText.getText();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.projectNameText = Page1Utils.createProjectNameInGroup("", composite);
        this.locationArea = new LocationArea(composite, this);
        this.setButtonLayoutData(this.locationArea.getBrowseButton());
        if (this.getWizard().getType() == WizardArtifactType.APPLICATION) {
            this.getContext().setExecutable(true);
            new FilteredContentComposite(this, true, composite, 4);
        } else {
            this.getContext().setExecutable(false);
            new FilteredContentComposite(this, false, composite, 4);
        }
        this.projectNameText.addListener(24, (Listener)new NameListener(this, this.getContext()));
        this.setButtonLayoutData(this.locationArea.getBrowseButton());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), S32DSWizardPlugin.makeHelpContextId(this.getWizard().getType(), 1));
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
        if (visible) {
            ProcessorContext currentContext = this.getContext().getCurrentContext();
            if (currentContext != null) {
                currentContext.reset();
                this.resetPages();
                this.projectNameText.setFocus();
            } else {
                this.updateState();
            }
        }
    }

    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    protected S32DSMultiPageTwo createPageTwoExec(String pageName, ProcessorContext execProcessorContext, S32DSMultiProjectWizard wizard) {
        return new S32DSMultiPageTwo(pageName, this.getWizard(), execProcessorContext);
    }

    protected S32DSMultiPageTwo createPageTwoLib(String pageName, ProcessorContext libProcessorContext, S32DSMultiProjectWizard wizard) {
        return new S32DSMultiPageTwo(pageName, this.getWizard(), libProcessorContext);
    }

    protected S32DSMultiPageTwo createPageTwo(String pageName, ProcessorContext context) {
        return new S32DSMultiPageTwo(pageName, this.getWizard(), context);
    }

    public IWizardPage getNextPage() {
        ProcessorContext processorContext = this.getContext().getCurrentProcessorContext();
        for (CProjectContext projectContext : processorContext.getProjectContexts()) {
            if (projectContext.getTemplate() == null || !this.validatePage().isOK()) continue;
            return this.getPageTwo(processorContext);
        }
        return null;
    }

    private S32DSMultiPageTwo getPageTwo(ProcessorContext processor) {
        if (processor == null) {
            return null;
        }
        S32DSMultiPageTwo pageTwo = this.getCreatePageTwo(processor);
        String projectName = this.getProjectName();
        pageTwo.setProjectName(projectName);
        return pageTwo;
    }

    private S32DSMultiPageTwo getCreatePageTwo(ProcessorContext processorContext) {
        boolean executable = this.getContext().isExecutable();
        Map<String, S32DSMultiPageTwo> pagesMap = executable ? this.exepages : this.libpages;
        S32DSMultiPageTwo pageTwo = pagesMap.get(processorContext.getKey());
        if (pageTwo == null) {
            pageTwo = executable ? this.createPageTwoExec(PAGE_NAME, processorContext, this.getWizard()) : this.createPageTwoLib(PAGE_NAME, processorContext, this.getWizard());
            pagesMap.put(processorContext.getKey(), pageTwo);
        }
        return pageTwo;
    }

    public S32DSMultiProjectWizard getWizard() {
        return (S32DSMultiProjectWizard)super.getWizard();
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public void setLabel(Composite c, String s) {
        Label l1 = new Label(c, 16384);
        l1.setLayoutData((Object)new GridData(16384));
        l1.setText(s);
        l1.setFont(c.getParent().getFont());
    }

    protected boolean filterProjectTypes(IProjectType p) {
        return p.getId().endsWith(this.getContext().isExecutable() ? ".exe" : ".lib");
    }

    public URI getLocationURI() {
        return this.locationArea.getProjectLocationURI();
    }

    public String getProjectName() {
        return this.getContext().getProjectBaseName();
    }

    @Override
    public String getProjectLocation() {
        if (!this.locationArea.isDefault()) {
            return Paths.get(this.getLocationURI()).toString();
        }
        return null;
    }

    public IProject getProjectHandle() {
        String projectName = this.getProjectName();
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    private IStatus validatePage() {
        IStatus status = Status.OK_STATUS;
        ProcessorConfiguration pConfiguration = this.getContext().getCurrentProcessorConfiguration();
        if (pConfiguration == null) {
            return new Status(4, "com.freescale.s32ds.cross.wizard", Messages.S32DSProjectWizard_processor_configuration_error);
        }
        String projectBaseName = this.getProjectBaseName();
        String fullPath = String.valueOf(this.locationArea.getProjectLocation()) + File.separator + projectBaseName;
        if (this.getContext().isMulticore()) {
            ProcessorContext currentProcessorContext = this.getContext().getCurrentProcessorContext();
            for (CProjectContext pc : currentProcessorContext.getProjectContexts()) {
                String name = projectBaseName == null || projectBaseName.isEmpty() ? "" : pc.getProjectName();
                status = this.validateProjectName(name);
                if (status.isOK()) {
                    status = this.validateProjectPath(fullPath);
                }
                if (status.isOK()) {
                    status = this.validateProjectPath(String.valueOf(fullPath) + File.separator + name);
                }
                if (status.isOK()) continue;
                return status;
            }
        } else {
            status = this.validateProjectName(projectBaseName);
            if (status.isOK()) {
                status = this.validateProjectPath(fullPath);
            }
        }
        if (status.isOK()) {
            status = this.checkProcessorConfiguration();
        }
        return status;
    }

    private IStatus checkProcessorConfiguration() {
        ProcessorConfiguration pConfiguration = this.getWizard().getContext().getCurrentProcessorConfiguration();
        if (pConfiguration == null) {
            return new Status(4, "com.freescale.s32ds.cross.wizard", Messages.S32DSMultiPageOne_data_not_init);
        }
        if (pConfiguration.getCoreNatureConfigurations().isEmpty()) {
            return new Status(4, "com.freescale.s32ds.cross.wizard", Messages.S32DSMultiPageOne_no_templates);
        }
        if (this.selectedProcessor == null) {
            return new Status(4, "com.freescale.s32ds.cross.wizard", Messages.S32DSMultiPageOne_processor_not_selected);
        }
        if (this.getContext().getSelectedToolChains().isEmpty()) {
            return new Status(4, "com.freescale.s32ds.cross.wizard", Messages.S32DSMultiPageOne_no_toolchains);
        }
        return Status.OK_STATUS;
    }

    private IStatus validateProjectName(String name) {
        return this.compositeNameValidator.validate(name);
    }

    private IStatus validateProjectPath(String path) {
        if (this.locationArea.isDefault()) {
            return this.compositePathValidator.validate(path);
        }
        return this.compositeNonDefaultPathValidator.validate(path);
    }

    public static void showError(String h, String s) {
        S32DSMultiPageOne.showMessage(h, s, 1, false);
    }

    public static void showMessage(String h, String s) {
        S32DSMultiPageOne.showMessage(h, s, 2, false);
    }

    public static void showMessage(String h, String s, int sev, boolean isSheet) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        shell.getDisplay().syncExec(() -> {
            boolean bl2 = MessageDialog.open((int)sev, (Shell)shell, (String)h, (String)s, (int)(isSheet ? 0x10000000 : 0));
        });
    }

    protected GeneralContext getContext() {
        return this.getWizard().getContext();
    }

    public ModelRegistry getRegistry() {
        return this.getContext().getRegistry();
    }

    protected HWModel getModel() {
        return this.getWizard().getModel();
    }

    public void resetPages() {
        this.exepages.clear();
        this.libpages.clear();
    }

    void setSelectedProcessor(ProcessorData processorData) {
        this.selectedProcessor = processorData;
    }

    public void updateState() {
        IStatus status = this.validatePage();
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
        } else {
            this.setErrorMessage(null);
        }
        this.setPageComplete(status.isOK());
    }
}

