/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.wizard.ParameterControl;
import com.freescale.s32ds.cross.wizard.page2.Page2AbstractManager;
import com.freescale.s32ds.cross.wizard.page2.Page2Utils;
import com.freescale.s32ds.cross.wizard.page2.S32DSMultiPageTwo;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GridManager
extends Page2AbstractManager {
    private final int mainRowCount;
    private final int dataRowCount;
    private final int dataSpan;
    private final int singleSpan = 2;
    private final boolean grabExcessVertical;
    private final int CELL_WIDTH = 150;
    private final int FIRST_COLUMN_CELL_WIDTH = 190;

    public GridManager(ProcessorContext processorContext, S32DSMultiPageTwo wizardPage, Composite parent) {
        this(processorContext, wizardPage, parent, false);
    }

    public GridManager(ProcessorContext processorContext, S32DSMultiPageTwo wizardPage, Composite parent, boolean grabExcessVertical) {
        super(processorContext, wizardPage, parent);
        this.grabExcessVertical = grabExcessVertical;
        int columnsCount = this.getColumnKeys().size();
        this.mainRowCount = columnsCount > 2 ? columnsCount : 3;
        this.dataRowCount = this.mainRowCount - 1;
        this.dataSpan = columnsCount > 2 ? 1 : 2;
    }

    @Override
    protected Composite createMainComposite(Composite parent, List<String> columnKeys, List<ParameterType> parameterTypes) {
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        if (columnKeys.size() < 5) {
            sc.setExpandHorizontal(true);
        }
        sc.setLayout((Layout)new GridLayout());
        sc.setLayoutData((Object)this.createCompositeGridData(this.getFullWidth(), 4, 4, true, this.isGrabExcessVertical()));
        Composite rootComposite = new Composite((Composite)sc, 2048);
        GridData createCompositeGridData = new GridData();
        rootComposite.setLayoutData((Object)createCompositeGridData);
        rootComposite.setLayout((Layout)new GridLayout(this.getColumnKeys().size(), false));
        sc.setContent((Control)rootComposite);
        return rootComposite;
    }

    @Override
    protected void customizeRow(List<ParameterControl> rowControls, ParameterType parameterType, Composite parentComposite) {
        for (ParameterControl parameterControl : rowControls) {
            GridData gd;
            Control control = parameterControl.getControl();
            if (control != null) {
                gd = new GridData(4, 4, true, false, this.dataSpan, 1);
                if ("SoC".equals(parameterControl.getContextKey())) {
                    gd.heightHint = this.getRowHeight();
                    gd.grabExcessHorizontalSpace = false;
                    gd.widthHint = 150;
                } else {
                    gd.widthHint = 190;
                    if ("sdks".equals(parameterControl.getParameterType().getTag())) {
                        gd.heightHint = this.getRowHeight() - 4;
                    }
                }
                control.setLayoutData((Object)gd);
                continue;
            }
            gd = new GridData(4, 4, true, false, this.dataSpan, 1);
            Label l = Page2Utils.createLabel("", parentComposite);
            l.setLayoutData((Object)gd);
        }
    }

    protected int getMainRowCount() {
        return this.mainRowCount;
    }

    protected int getDataRowCount() {
        return this.dataRowCount;
    }

    public boolean isGrabExcessVertical() {
        return this.grabExcessVertical;
    }

    private GridData createCompositeGridData(int width, int hStyle, int vStyle, boolean hGrab, boolean vGrab) {
        GridData gd = new GridData(hStyle, vStyle, hGrab, vGrab);
        gd.minimumWidth = width;
        gd.widthHint = width;
        return gd;
    }
}

