/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cross.core.model.AffectType;
import com.freescale.s32ds.cross.core.model.EditorType;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.ValueType;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import com.freescale.s32ds.cross.wizard.ContextQualifier;
import com.freescale.s32ds.cross.wizard.GraphicConstants;
import com.freescale.s32ds.cross.wizard.ParameterControl;
import com.freescale.s32ds.cross.wizard.page2.CoreActivateListener;
import com.freescale.s32ds.cross.wizard.page2.IPage2Manager;
import com.freescale.s32ds.cross.wizard.page2.Messages;
import com.freescale.s32ds.cross.wizard.page2.OpModeActivateListener;
import com.freescale.s32ds.cross.wizard.page2.Page2Utils;
import com.freescale.s32ds.cross.wizard.page2.S32DSMultiPageTwo;
import com.nxp.s32ds.cle.cdt.sdk.ui.property.WizardSdksDialogCellEditor;
import com.nxp.s32ds.cle.cdt.wizard.core.WizardProjectContextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class Page2AbstractManager
implements IPage2Manager {
    private static final String LINUX_PLATFORM = "Linux";
    protected static final String FIRST_COLUMN = "SoC";
    private static final List<EditorType> grayed = Arrays.asList(EditorType.LABEL, EditorType.CHECKBOX);
    private final ProcessorContext processorContext;
    private final List<ParameterControl> parameterControls = new ArrayList<ParameterControl>();
    private final S32DSMultiPageTwo wizardPage;
    private final List<String> columnKeys = new ArrayList<String>();
    private Composite mainComposite;
    private final List<ParameterType> parameterTypes;
    private final Composite parent;
    private boolean enabled = true;
    private static int ROW_HEIGHT_DEFAULT = 25;
    private static int WIDTH_DEFAULT = 700;

    public Page2AbstractManager(ProcessorContext processorContext, S32DSMultiPageTwo wizardPage, Composite parent) {
        this.processorContext = processorContext;
        this.wizardPage = wizardPage;
        this.columnKeys.addAll(this.createColumnKeys(processorContext));
        this.parameterTypes = processorContext.getParameterTypes();
        this.parent = parent;
        if (processorContext.isExecutable()) {
            for (CProjectContext pc : processorContext.getProjectContexts()) {
                pc.setActive(true);
            }
        } else {
            CProjectContext active = processorContext.getDefaultEnabledProjectContext();
            if (active != null) {
                active.setActive(true);
            }
        }
    }

    @Override
    public void createContents() {
        this.createContents(WIDTH_DEFAULT, ROW_HEIGHT_DEFAULT);
    }

    @Override
    public void createContents(int fullWidth, int rowHeight) {
        this.setFullWidth(fullWidth);
        this.setRowHeight(rowHeight);
        this.mainComposite = this.createMainComposite(this.parent, this.columnKeys, this.parameterTypes);
        int rowNumber = 0;
        while (rowNumber < this.parameterTypes.size()) {
            ParameterType parameterType = this.parameterTypes.get(rowNumber);
            boolean showParameter = this.processorContext.isAffected(parameterType.getTag());
            if (showParameter) {
                this.parameterControls.addAll(this.createRow(this.processorContext, parameterType, rowNumber));
            }
            ++rowNumber;
        }
        this.mainComposite.pack();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.mainComposite.setEnabled(false);
        for (ParameterControl c : this.parameterControls) {
            if (c.getControl() == null || c.getControl().isDisposed()) continue;
            c.getControl().setEnabled(enabled);
        }
    }

    public int getRowHeight() {
        return ROW_HEIGHT_DEFAULT;
    }

    private void setRowHeight(int rowHeight) {
        ROW_HEIGHT_DEFAULT = rowHeight;
    }

    public int getFullWidth() {
        return WIDTH_DEFAULT;
    }

    private void setFullWidth(int fullWidth) {
        WIDTH_DEFAULT = fullWidth;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public WizardPage getWizardPage() {
        return this.wizardPage;
    }

    public List<String> getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }

    public ProcessorContext getProcessorContext() {
        return this.processorContext;
    }

    public List<ParameterControl> getParameterControls() {
        return this.parameterControls;
    }

    public List<ParameterType> getParameterTypes() {
        return Collections.unmodifiableList(this.parameterTypes);
    }

    @Override
    public boolean isAnyChecked() {
        for (CProjectContext projectContext : this.processorContext.getProjectContexts()) {
            if (!projectContext.isActive()) continue;
            return true;
        }
        return false;
    }

    public List<ParameterControl> getControls() {
        return this.parameterControls;
    }

    @Override
    public void update() {
        this.updateProjectNames();
    }

    public void update(ChangeResult result) {
        if (result.hasWarning()) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (String)Messages.Page2AbstractManager_StudioWizardWarning, (String)result.getWarningMessage());
        }
        for (ContextChange contextChange : result.getContextChanges()) {
            this.update(contextChange);
        }
        this.wizardPage.setPageComplete(this.wizardPage.validatePage());
    }

    public Composite getMainComposite() {
        return this.mainComposite;
    }

    protected abstract Composite createMainComposite(Composite var1, List<String> var2, List<ParameterType> var3);

    protected void customizeRow(List<ParameterControl> rowControls, ParameterType parameterType, Composite parentComposite) {
    }

    protected void customizeCell(ParameterControl parameterControl) {
        Control control = parameterControl.getControl();
        ParameterType parameterType = parameterControl.getParameterType();
        if (control != null && !FIRST_COLUMN.equals(parameterControl.getContextKey()) && !grayed.contains(parameterType.getEditorType())) {
            control.setBackground(GraphicConstants.WHITE);
        }
    }

    private List<ParameterControl> createRow(ProcessorContext processorContext, ParameterType parameterType, int rowNumber) {
        ArrayList<ParameterControl> rowControls = new ArrayList<ParameterControl>();
        Composite parentComposite = this.getMainComposite();
        Parameter parameter = processorContext.getParameter(parameterType);
        int colNumber = 0;
        while (colNumber < this.columnKeys.size()) {
            String columnKey = this.columnKeys.get(colNumber);
            CProjectContext projectContext = processorContext.getProjectContext(columnKey);
            boolean showCell = this.showCell(columnKey, parameter, projectContext, processorContext);
            ParameterControl control = null;
            if (showCell) {
                control = this.createControl(columnKey, projectContext, parameter, rowNumber, colNumber, parentComposite);
            } else if (parameter.isSingle()) {
                control = new ParameterControl(columnKey, processorContext, parameterType, null, rowNumber, colNumber, false);
            } else {
                Label createLabel = Page2Utils.createLabel("", parentComposite);
                createLabel.setEnabled(false);
                control = new ParameterControl(columnKey, processorContext, parameterType, (Control)createLabel, rowNumber, colNumber, false);
            }
            if (control != null) {
                this.customizeCell(control);
                rowControls.add(control);
            }
            ++colNumber;
        }
        this.customizeRow(rowControls, parameterType, parentComposite);
        for (ParameterControl c : rowControls) {
            this.parameterControls.add(c);
            c.updateState();
        }
        return rowControls;
    }

    private boolean showCell(String columnKey, Parameter parameter, CProjectContext projectContext, ProcessorContext processorContext) {
        if (!parameter.isVisible()) {
            return false;
        }
        boolean processorAffected = AffectType.isAffected((Parameter)parameter, (List)processorContext.getCoreNatures(), (boolean)processorContext.isExecutable());
        if (projectContext == null && FIRST_COLUMN.equals(columnKey)) {
            return processorAffected;
        }
        boolean applicableForProject = projectContext.isAffected(parameter.getTag());
        if (parameter.isSingle() && projectContext.isExecutable()) {
            boolean bl = applicableForProject = projectContext.isAutoStart() ? processorAffected : false;
        }
        if (parameter.getTag().equals("debugger")) {
            List elements;
            DataSet dataSetInitial;
            CoreNatureData coreNature;
            Boolean value;
            int indexColumn = this.columnKeys.indexOf(columnKey);
            if (indexColumn == 1) {
                return true;
            }
            String platformId = projectContext.getStringValue("platform");
            if (LINUX_PLATFORM.equals(platformId) && (value = (coreNature = projectContext.getCoreNature()).getBooleanValue("enableDebugger")) != null) {
                return value;
            }
            if (!projectContext.isAutoStart() && (dataSetInitial = WizardProjectContextUtil.getDebugerDataSetByContextParameter(projectContext, parameter)) != null && (elements = dataSetInitial.getElements()).size() > 0) {
                ConfigurationData configurationData = (ConfigurationData)elements.get(0);
                projectContext.setValue("debugger", (Object)configurationData.getId());
            }
            return projectContext.isAutoStart();
        }
        return applicableForProject;
    }

    private Set<String> createColumnKeys(ProcessorContext processorContext) {
        LinkedHashSet<String> columnKeys = new LinkedHashSet<String>();
        columnKeys.add(FIRST_COLUMN);
        for (CProjectContext pc : processorContext.getProjectContexts()) {
            columnKeys.add(pc.getContextId());
        }
        return columnKeys;
    }

    private ParameterControl createControl(String contextKey, final CProjectContext projectContext, final Parameter parameter, int row, int column, Composite parent) {
        Label control = null;
        if (projectContext == null && contextKey.equals(FIRST_COLUMN)) {
            String unit = parameter.getUnit();
            String text = unit.isEmpty() ? parameter.getName() : String.valueOf(parameter.getName()) + ", " + unit;
            control = Page2Utils.createLabel(text, parameter.getDescription(), parent);
        } else if (!projectContext.containsParameter(parameter.getTag())) {
            control = Page2Utils.createLabel("", parent);
        } else if ("core".equals(parameter.getTag()) || "coreType".equals(parameter.getTag())) {
            CoreActivateListener l = new CoreActivateListener(this, projectContext, this.wizardPage);
            control = Page2Utils.createChecbox(projectContext, projectContext.getCoreNatureName(), projectContext.isActive(), (SelectionListener)l, parent);
        } else if ("projectName".equals(parameter.getTag())) {
            control = Page2Utils.createText(projectContext.getProjectName(), parent);
        } else if ("sdks".equals(parameter.getTag())) {
            WizardSdksDialogCellEditor.WizardSdksDialogEditorListener l = sdksIds -> this.update(projectContext.setSdkList(sdksIds));
            control = Page2Utils.createSDKDialog(projectContext, l, parent);
        } else if (EditorType.SELECTION == parameter.getEditorType() && "opmode".equals(parameter.getTag())) {
            OpModeActivateListener opmodeListener = new OpModeActivateListener(this, projectContext, this.wizardPage, parameter);
            control = Page2Utils.createComboIfDataPresent(projectContext, parameter, (SelectionListener)opmodeListener, parent);
        } else if (EditorType.SELECTION == parameter.getEditorType() && !"opmode".equals(parameter.getTag())) {
            SelectionAdapter l = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String s = ((Combo)e.widget).getText();
                    ChangeResult result = projectContext.setValue(parameter.getTag(), (Object)s);
                    Page2AbstractManager.this.update(result);
                }
            };
            control = Page2Utils.createComboIfDataPresent(projectContext, parameter, (SelectionListener)l, parent);
        } else if (EditorType.CHECKBOX == parameter.getEditorType()) {
            SelectionAdapter l = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChangeResult result = projectContext.setValue(parameter.getTag(), (Object)((Button)e.getSource()).getSelection());
                    Page2AbstractManager.this.update(result);
                }
            };
            control = Page2Utils.createChecbox(projectContext, "", projectContext.getBooleanValue(parameter.getTag()), (SelectionListener)l, parent);
        } else if (EditorType.SPINNER == parameter.getEditorType()) {
            control = Page2Utils.createSpinner(projectContext, parameter, this, parent);
        } else {
            String str = Page2Utils.getCommonLabelValue(parameter, projectContext);
            control = Page2Utils.createLabel(str, parent);
        }
        control.setLayoutData((Object)new GridData());
        return new ParameterControl(contextKey, this.processorContext, parameter.getType(), (Control)control, row, column, true);
    }

    private void update(ContextChange contextChange) {
        this.updateProjectNames();
        if (contextChange == null) {
            return;
        }
        if (!(contextChange.getContext() instanceof CProjectContext)) {
            return;
        }
        CProjectContext projectContext = (CProjectContext)contextChange.getContext();
        ContextQualifier cq = new ContextQualifier();
        cq.add(projectContext.getContextId(), new String[0]);
        List<ParameterControl> updateControls = ParameterControl.filterControls(projectContext, this.getControls());
        for (ParameterControl updateControl : updateControls) {
            this.updateParameterControl(contextChange, updateControl, projectContext);
        }
        List relativeContexts = projectContext.getRelatedContexts();
        for (ProjectContext relContext : relativeContexts) {
            ContextQualifier rcq = new ContextQualifier();
            rcq.add(projectContext.getContextId(), new String[0]);
            List<ParameterControl> controls = ParameterControl.filterControls((CProjectContext)relContext, this.getControls());
            for (ParameterControl updateControl : controls) {
                this.updateParameterControl(contextChange, updateControl, projectContext);
            }
        }
    }

    private void updateParameterControl(ContextChange contextChange, ParameterControl updateControl, CProjectContext projectContext) {
        Parameter parameter;
        ParameterType parameterType = updateControl.getParameterType();
        Parameter parameter2 = parameter = parameterType != null ? projectContext.getParameter(parameterType) : null;
        if (parameter == null || updateControl.getControl() == null) {
            return;
        }
        if (parameterType == null) {
            return;
        }
        Control control = updateControl.getControl();
        boolean autostart = projectContext.isAutoStart();
        if (control instanceof Combo) {
            DataSet dataSet = contextChange.getDataSet(updateControl.getTag());
            Object value = contextChange.getValue(updateControl.getTag());
            Page2Utils.setComboData((Combo)control, dataSet, value);
        } else if (control instanceof Button && EditorType.CHECKBOX == parameter.getType().getEditorType()) {
            ((Button)control).setSelection(projectContext.getBooleanValue(parameter.getType().getTag()));
        } else if (control instanceof Spinner) {
            Page2Utils.setSpinnerData((Spinner)control, projectContext.getLongValue(parameter.getType().getTag()));
        } else if (control instanceof Text && parameter.getType().getValueType() == ValueType.LONG) {
            String v = projectContext.getStringValue(parameterType.getTag());
            ((Text)control).setText(Page2Utils.formatLongTextValue(v));
        } else if (control instanceof Label && (parameter.isSingle() && autostart || !parameter.isSingle()) && !"debugger".equals(parameter.getTag())) {
            ((Label)control).setText(Page2Utils.getCommonLabelValue(parameter, projectContext));
        }
    }

    private void updateProjectNames() {
        List<ParameterControl> projectNameControls = ParameterControl.filterControls(this.getControls(), "projectName");
        for (ParameterControl control : projectNameControls) {
            if (!(control.getControl() instanceof Text) || control.getProjectContext() == null) continue;
            ((Text)control.getControl()).setText(control.getProjectContext().getProjectName());
        }
    }
}

