/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cdt.core.OSFamily;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableFactory {
    public static Table createTable(Composite parent, List<String> columnKeys, int rowsNumber, int fullWidth, int rowHeight) {
        Table table = new Table(parent, 2052);
        GridData gd = TableFactory.getGridTableData(rowsNumber, fullWidth, rowHeight);
        TableFactory.settupTable(table, gd);
        TableFactory.setCollumns(columnKeys, table);
        TableFactory.setColumnsSize(table, columnKeys);
        table.addListener(11, listener -> TableFactory.setColumnsSize(table, columnKeys));
        table.pack();
        table.addDisposeListener(listener -> {
            Control[] controlArray = table.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (!c.isDisposed()) {
                    c.dispose();
                }
                ++n2;
            }
        });
        TableFactory.setTableItemHeight(table, rowHeight);
        return table;
    }

    private static void setCollumns(List<String> columnKeys, Table table) {
        for (String k : columnKeys) {
            new TableColumn(table, 0).setText(k);
        }
    }

    private static void settupTable(Table table, GridData gd) {
        table.setLayoutData((Object)gd);
        table.setSortDirection(128);
        table.setLinesVisible(true);
        table.getHorizontalBar().setEnabled(true);
    }

    private static GridData getGridTableData(int rowsNumber, int fullWidth, int rowHeight) {
        GridData gd = new GridData(4, 4, true, false);
        gd.minimumWidth = fullWidth;
        gd.minimumHeight = rowsNumber * rowHeight;
        gd.heightHint = -1;
        return gd;
    }

    private static void setColumnsSize(Table table, List<String> columnKeys) {
        int dataColumns = columnKeys.size() - 1;
        int width = table.getClientArea().width;
        int firstWidth = columnKeys.size() == 2 ? width / 3 : width / columnKeys.size();
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn c = table.getColumn(i);
            if (i == 0) {
                c.setWidth(firstWidth);
            } else {
                int columnWidth = (width - firstWidth) / dataColumns;
                if (columnWidth < 150) {
                    columnWidth = 150;
                }
                c.setWidth(columnWidth);
            }
            ++i;
        }
    }

    public static void setTableItemHeight(Table table, int height) {
        if (OSFamily.WINDOWS.isCurrent()) {
            try {
                Method setItemHeightMethod = table.getClass().getDeclaredMethod("setItemHeight", Integer.TYPE);
                setItemHeightMethod.setAccessible(true);
                setItemHeightMethod.invoke((Object)table, height);
            }
            catch (Exception e) {
                S32DSWizardPlugin.log(e);
            }
        }
    }
}

