/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddConfigID
extends ProcessRunner {
    private static final String PROJECT_NAME = "projectName";
    private static final String SUPER_CONFIG_ID = "superID";
    private static final String CONFIG_NAME = "name";
    private static final String CONFIG_ID = "id";

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        if (template.getValueStore().get("EARLY_DONE") != null) {
            return;
        }
        if (args == null || args.length < 3) {
            S32DSWizardPlugin.logWarning("Data for AddConfigID should contain more input parameters");
            return;
        }
        String id = null;
        String nm = null;
        String su = null;
        String pr = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument pa = processArgumentArray[n2];
            pa.resolve();
            String name = pa.getName();
            if (pa.getParameterType() == 1) {
                if (CONFIG_ID.equals(name)) {
                    id = pa.getSimpleValue();
                } else if (CONFIG_NAME.equals(name)) {
                    nm = pa.getSimpleValue();
                } else if (SUPER_CONFIG_ID.equals(name)) {
                    su = pa.getSimpleValue();
                } else if (PROJECT_NAME.equals(name)) {
                    pr = pa.getSimpleValue();
                }
            }
            ++n2;
        }
        if (su == null) {
            return;
        }
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(pr);
        ICProjectDescription des = CProjectDescriptionManager.getInstance().getProjectDescription(proj);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = des.getConfigurations();
        int n3 = iCConfigurationDescriptionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n4];
            if (c.getId().startsWith(su)) {
                try {
                    des.createConfiguration(id, nm, c);
                    CProjectDescriptionManager.getInstance().setProjectDescription(proj, des);
                    S32DSWizardPlugin.logWarning("AddConfigID: Added config Name=" + nm);
                }
                catch (CoreException e) {
                    S32DSWizardPlugin.log(e);
                }
            }
            ++n4;
        }
    }
}

