/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.wizard.core;

import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.LibraryContext;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilteringParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;

public class WizardProjectContextSdkFilter
implements SdkFilteringParameters {
    private CProjectContext projectContext;

    public WizardProjectContextSdkFilter(CProjectContext projectContext) {
        this.projectContext = Objects.requireNonNull(projectContext);
    }

    public String getFamilyId() {
        ProcessorData processor = this.projectContext.getProcessor();
        if (processor != null) {
            FamilyData family = processor.getFamily();
            return family != null ? family.getId() : "";
        }
        return "";
    }

    public String getDeviceId() {
        ProcessorData processor = this.projectContext.getProcessor();
        if (processor != null) {
            return !processor.getDevice().isEmpty() ? processor.getDevice() : processor.getId();
        }
        return "";
    }

    public String getDeviceCoreId() {
        String opmodeCoreID = this.projectContext.getContextValue("opmodeCoreId");
        if (opmodeCoreID != null && !opmodeCoreID.isEmpty()) {
            return opmodeCoreID;
        }
        CoreNatureData coreNature = this.projectContext.getCoreNature();
        if (coreNature != null) {
            return coreNature.getCoreNatureId();
        }
        return "";
    }

    public String getDeviceRevisionId() {
        ProcessorData processor = this.projectContext.getProcessor();
        if (processor != null) {
            return processor.getDeviceRevision();
        }
        return "";
    }

    public String getCoreId() {
        CoreNatureData coreNature = this.projectContext.getCoreNature();
        if (coreNature != null) {
            return coreNature.getStringValue("hardwareCoreId");
        }
        return "";
    }

    public String getLangId() {
        return this.projectContext.getStringValue("language");
    }

    public String getTargetPlatform() {
        ProcessorData processor = this.projectContext.getProcessor();
        if (processor != null) {
            return processor.getPlatform();
        }
        return "";
    }

    public Collection<IToolChain> getToolChains() {
        ArrayList<IToolChain> toolChains = new ArrayList<IToolChain>();
        String buildArtifactProjectTypeId = this.projectContext.getTargetProjectTypeId();
        IProjectType[] iProjectTypeArray = ManagedBuildManager.getDefinedProjectTypes();
        int n = iProjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectType pt = iProjectTypeArray[n2];
            if (pt.getBuildArtefactType() != null && pt.getBuildArtefactType().getId().equals(buildArtifactProjectTypeId)) {
                IConfiguration[] iConfigurationArray = pt.getConfigurations();
                int n3 = iConfigurationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfiguration cfg = iConfigurationArray[n4];
                    String cfgToolChainId = cfg.getToolChain().getSuperClass().getId();
                    if (cfgToolChainId.equals(this.projectContext.getToolChainId())) {
                        toolChains.add(cfg.getToolChain());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (toolChains.isEmpty()) {
            toolChains.add(ManagedBuildManager.getExtensionToolChain((String)this.projectContext.getToolChainId()));
        }
        return toolChains;
    }

    public boolean isLibrary() {
        return this.projectContext instanceof LibraryContext;
    }
}

