/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.diagnostic;

import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnosticElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;

public class MigrationDiagnostic {
    private final List<MigrationDiagnostic> children = new ArrayList<MigrationDiagnostic>();
    private final MigrationDiagnostic parent;
    private final MigrationDiagnosticElementType type;
    private final String id;
    private final String name;
    private Object value;

    public MigrationDiagnostic(IProject project) {
        this(null, MigrationDiagnosticElementType.ROOT, null, null);
        if (project == null) {
            throw new IllegalArgumentException("Project is null");
        }
        this.setValue(project);
    }

    protected MigrationDiagnostic(MigrationDiagnostic parent, MigrationDiagnosticElementType type, String id, String name) {
        this.parent = parent;
        if (type == null) {
            throw new IllegalArgumentException("Type is null");
        }
        this.type = type;
        this.id = id;
        this.name = name;
    }

    public MigrationDiagnostic getParent() {
        return this.parent;
    }

    public MigrationDiagnosticElementType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public List<MigrationDiagnostic> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public MigrationDiagnostic subDiagnostic(MigrationDiagnosticElementType type, String id, String name) {
        MigrationDiagnostic diagnostic = new MigrationDiagnostic(this, type, id, name);
        this.children.add(diagnostic);
        return diagnostic;
    }
}

