/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.internal.refactoring.text;

import com.nxp.s32ds.ext.ide.internal.refactoring.IdeRefactoringActivator;
import com.nxp.s32ds.ext.ide.internal.refactoring.text.IdeTextBufferedDocumentContext;
import com.nxp.s32ds.ext.ide.internal.refactoring.text.IdeTextDocumentContext;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;

public class IdeTextDocuments {
    public static final String DIRTY_DOCUMENTS_HANDLER = "com.nxp.s32ds.ext.ide.refactoring.text.dirty.documents.handler";
    private final Map<IFile, IdeTextDocumentContext> dirtyDocuments = IdeTextDocuments.initDirtyDocuments();

    public Map<IFile, IdeTextDocumentContext> getDirtyDocuments() {
        return this.dirtyDocuments;
    }

    public IdeTextDocumentContext createDocumentContext(IFile file, IProgressMonitor monitor) throws CoreException {
        IdeTextDocumentContext context = this.dirtyDocuments.get(file);
        if (context != null) {
            return context;
        }
        return new IdeTextBufferedDocumentContext(file, monitor);
    }

    private static Map<IFile, IdeTextDocumentContext> initDirtyDocuments() {
        RcpStatusHandler handler = RcpStatusHandlers.getStatusHandlerService().getStatusHandler(DIRTY_DOCUMENTS_HANDLER);
        if (handler != null) {
            try {
                return (Map)handler.handleStatus(Status.OK_STATUS, null);
            }
            catch (CoreException e) {
                IdeRefactoringActivator.getInstance().log(e.getStatus());
            }
        }
        return Collections.emptyMap();
    }
}

