/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.refactoring.text;

import com.nxp.s32ds.ext.ide.internal.refactoring.text.IdeTextLineEdit;
import com.nxp.s32ds.ext.ide.internal.refactoring.text.IdeTextRefactoring;
import com.nxp.s32ds.ext.ide.internal.refactoring.text.IdeTextReplaceEdit;
import com.nxp.s32ds.ext.ide.refactoring.IdeRefactorings;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextEdit;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextMatch;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Refactoring;

public class IdeTextRefactorings {
    public static final String REFACTORING_TEXT_HANDLER = "com.nxp.s32ds.ext.ide.refactoring.text.handler";

    public static IdeTextEdit toReplace(IdeTextMatch match, String text) {
        return new IdeTextReplaceEdit(match, text);
    }

    public static IdeTextEdit toDeleteLine(IdeTextMatch match) {
        return IdeTextLineEdit.deleteLine(match);
    }

    public static IdeTextEdit toInsertLineBefore(IdeTextMatch match, String text) {
        return IdeTextLineEdit.insertLineBefore(match, text);
    }

    public static IdeTextEdit toInsertLineAfter(IdeTextMatch match, String text) {
        return IdeTextLineEdit.insertLineAfter(match, text);
    }

    public static IdeTextEdit toPrependTextToLine(IdeTextMatch match, String text) {
        return IdeTextLineEdit.prependText(match, text);
    }

    public static IdeTextEdit toAppendTextToLine(IdeTextMatch match, String text) {
        return IdeTextLineEdit.appendText(match, text);
    }

    public static List<IdeTextEdit> toEdit(List<? extends IdeTextMatch> matches, Function<IdeTextMatch, IdeTextEdit> function) {
        return matches.stream().map(m -> (IdeTextEdit)function.apply((IdeTextMatch)m)).collect(Collectors.toList());
    }

    public static void perform(IProgressMonitor monitor, List<IdeTextEdit> edits) throws CoreException {
        if (edits.size() > 0) {
            IdeRefactorings.perform(IdeTextRefactorings.createRefactoring(edits), monitor);
        }
    }

    public static IStatus performInteractive(List<IdeTextEdit> edits) throws CoreException {
        if (edits.size() == 0) {
            return Status.OK_STATUS;
        }
        Object result = RcpStatusHandlers.handleStatus((String)REFACTORING_TEXT_HANDLER, (IStatus)Status.OK_STATUS, (Object)IdeTextRefactorings.createRefactoring(edits));
        if (!(result instanceof IStatus)) {
            throw new IllegalStateException("Illegal result of status handling");
        }
        return (IStatus)result;
    }

    private static Refactoring createRefactoring(List<IdeTextEdit> edits) {
        return new IdeTextRefactoring(edits);
    }
}

