/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.refactoring.text;

import com.nxp.s32ds.ext.ide.internal.refactoring.Messages;
import com.nxp.s32ds.ext.ide.refactoring.IdeSearchScope;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextMatch;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextSearchRequestor;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextSearchScope;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchScope;

public class IdeTextSearches {
    public static <T extends IdeTextMatch> List<T> find(IProgressMonitor monitor, IdeTextSearchScope scope, IdeTextSearchRequestor<T> requestor, Pattern pattern) throws CoreException {
        IStatus status = TextSearchEngine.create().search((TextSearchScope)scope, requestor, pattern, monitor);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        return requestor.getMatches();
    }

    public static List<IdeTextMatch> findWord(IProgressMonitor monitor, IProject project, IdeSearchScope scope, String searchString) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor).checkCanceled();
        subMonitor.setTaskName(NLS.bind((String)Messages.IdeTextRefactoringsInternal_find_0, (Object)searchString));
        IdeTextSearchScope searchScope = IdeTextSearchScope.create(project, scope, false);
        IdeTextSearchRequestor<IdeTextMatch> requestor = IdeTextSearchRequestor.create(searchString);
        Pattern pattern = IdeTextSearches.createWordPattern(searchString);
        return IdeTextSearches.find((IProgressMonitor)subMonitor, searchScope, requestor, pattern);
    }

    public static List<IdeTextMatch> find(IProgressMonitor monitor, IProject project, IdeSearchScope scope, Pattern pattern) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor).checkCanceled();
        subMonitor.setTaskName(NLS.bind((String)Messages.IdeTextRefactoringsInternal_find_0, (Object)pattern.pattern()));
        IdeTextSearchScope searchScope = IdeTextSearchScope.create(project, scope, false);
        IdeTextSearchRequestor<IdeTextMatch> requestor = IdeTextSearchRequestor.create(pattern.pattern());
        return IdeTextSearches.find((IProgressMonitor)subMonitor, searchScope, requestor, pattern);
    }

    public static Pattern createWordPattern(String searchString) {
        Pattern pattern = Pattern.compile(String.format("\\b%s\\b", Pattern.quote(searchString)));
        return pattern;
    }
}

