/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.debugger.internal.connections.registry;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.ext.rcp.registry.ConfigurationElementDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;

public class DebuggerConnectionDescriptorImpl
extends ConfigurationElementDescriptor
implements DebuggerConnectionDescriptor {
    public static final String ID_ATTRIBUTE = "id";
    public static final String CONNECTION_NAME_ATTRIBUTE = "name";
    public static final String CONNECTION_DESCRIPTION_ATTRIBUTE = "description";
    public static final String CONNECTION_DEBUGGER_ID = "debuggerId";
    public static final String CONNECTION_IS_ETHERNET_TYPE = "useEthernet";
    public static final String CONNECTION_PRIORITY = "priority";
    public static final String CONNECTION_DEBUGGER = "debugger";
    private final Collection<String> DEBUGGER_IDS = new HashSet<String>();

    public DebuggerConnectionDescriptorImpl(IConfigurationElement configurationElement) {
        super(configurationElement);
        Stream.of(configurationElement.getChildren(CONNECTION_DEBUGGER)).forEach(debuggerElement -> {
            boolean bl = this.DEBUGGER_IDS.add(debuggerElement.getAttribute(ID_ATTRIBUTE));
        });
        this.addSubstitution(ID_ATTRIBUTE, ID_ATTRIBUTE);
        this.addSubstitution(CONNECTION_NAME_ATTRIBUTE, CONNECTION_NAME_ATTRIBUTE);
        this.addSubstitution(CONNECTION_DESCRIPTION_ATTRIBUTE, CONNECTION_DESCRIPTION_ATTRIBUTE);
    }

    @Override
    public String getConnectionName() {
        return this.getAttribute(CONNECTION_NAME_ATTRIBUTE);
    }

    @Override
    public String getConnectionDescription() {
        return this.getAttribute(CONNECTION_DESCRIPTION_ATTRIBUTE);
    }

    @Override
    public boolean supportsDebuggerId(String debuggerId) {
        return this.DEBUGGER_IDS.contains(debuggerId);
    }

    @Override
    public boolean isEthernetConnection() {
        return Boolean.parseBoolean(this.getAttribute(CONNECTION_IS_ETHERNET_TYPE));
    }

    @Override
    public int getPriority() {
        try {
            return Integer.parseInt(this.getAttribute(CONNECTION_PRIORITY));
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }
}

