/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.debugger.internal.connections.registry;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnection;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionAccessor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DebuggerConnectionImpl
extends BaseRegistry
implements DebuggerConnection {
    private final Collection<DebuggerConnectionDescriptor> debuggerDeviceDescriptors = new HashSet<DebuggerConnectionDescriptor>();
    private final Map<DebuggerConnectionDescriptor, DebuggerConnectionAccessor> deviceDescriptorToDeviceAccessor = new HashMap<DebuggerConnectionDescriptor, DebuggerConnectionAccessor>();

    @Override
    public Collection<DebuggerConnectionDescriptor> getConnectionDeviceDescriptors() {
        HashSet<DebuggerConnectionDescriptor> descriptors = new HashSet<DebuggerConnectionDescriptor>(this.debuggerDeviceDescriptors);
        return descriptors;
    }

    @Override
    public void addDeviceDescriptor(DebuggerConnectionDescriptor descriptor, DebuggerConnectionAccessor accessor) {
        this.debuggerDeviceDescriptors.add(descriptor);
        this.deviceDescriptorToDeviceAccessor.put(descriptor, accessor);
    }

    @Override
    public void removeDeviceDescriptor(DebuggerConnectionDescriptor descriptor) {
        this.debuggerDeviceDescriptors.remove(descriptor);
        this.deviceDescriptorToDeviceAccessor.remove(descriptor);
    }

    @Override
    public DebuggerConnectionDescriptor getDebuggerConnectionDeviceDescriptorByName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (DebuggerConnectionDescriptor descriptor : this.debuggerDeviceDescriptors) {
            if (!name.startsWith(descriptor.getConnectionName())) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public DebuggerConnectionAccessor getDebuggerConnectionDeviceAccessorByName(String name) {
        DebuggerConnectionDescriptor descriptor = this.getDebuggerConnectionDeviceDescriptorByName(name);
        return descriptor != null ? this.deviceDescriptorToDeviceAccessor.get(descriptor) : null;
    }
}

