/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.collateral.internal.core;

import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import com.nxp.s32ds.rcp.collateral.CollateralRegistry;
import com.nxp.s32ds.rcp.collateral.CollateralService;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.util.tracker.ServiceTracker;

public class CollateralCoreActivator
extends RcpBundle {
    private static final String BUNDLE_ID = "com.nxp.s32ds.cle.ide.collateral.core";
    private ServiceTracker<CollateralService, CollateralService> collateralServiceTracker;
    private CollateralRegistry collateralRegistry;
    private CollateralService service;
    private Preferences preferenceStore;
    private static CollateralCoreActivator instance;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        String collateralRegistryClassName = CollateralService.class.getName();
        this.collateralServiceTracker = new ServiceTracker(context, collateralRegistryClassName, null);
        this.clearOldMarkers();
        this.collateralServiceTracker.open();
        this.service = (CollateralService)this.collateralServiceTracker.getService();
    }

    protected String getBundleId() {
        return BUNDLE_ID;
    }

    public static CollateralCoreActivator getInstance() {
        return instance;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.collateralRegistry = null;
        this.service = null;
        this.collateralServiceTracker.close();
        this.collateralServiceTracker = null;
        instance = null;
    }

    private void clearOldMarkers() {
        try {
            IMarker[] findMarkers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("com.nxp.s32ds.cle.ide.software.manager.collateral.marker", false, 1);
            if (findMarkers != null && findMarkers.length > 0) {
                IMarker[] iMarkerArray = findMarkers;
                int n = findMarkers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker iMarker = iMarkerArray[n2];
                    iMarker.delete();
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            this.logError(e.getMessage());
        }
    }

    public CollateralRegistry getCollateralRegistry() {
        if (this.collateralRegistry == null) {
            this.collateralRegistry = this.service.getCollateralRegistry();
        }
        return this.collateralRegistry;
    }

    public Preferences getPreferenceForSoftwareManager() {
        if (this.preferenceStore == null) {
            this.preferenceStore = ConfigurationScope.INSTANCE.getNode(BUNDLE_ID);
        }
        return this.preferenceStore;
    }

    public void savePreferences() {
        if (this.preferenceStore != null) {
            try {
                this.preferenceStore.flush();
            }
            catch (BackingStoreException e) {
                this.logError(e.getMessage());
            }
        }
    }
}

