/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.collateral.internal.core.parsers;

import com.nxp.s32ds.cle.ide.collateral.internal.core.CollateralCoreActivator;
import com.nxp.s32ds.cle.ide.collateral.internal.core.handlers.Messages;
import com.nxp.s32ds.rcp.collateral.CollateralFeature;
import com.nxp.s32ds.rcp.collateral.CollateralObject;
import com.nxp.s32ds.rcp.collateral.CollateralPack;
import com.nxp.s32ds.rcp.collateral.CollateralRegistry;
import com.nxp.s32ds.rcp.collateral.CollateralResource;
import com.nxp.s32ds.rcp.collateral.CollateralResourceType;
import com.nxp.s32ds.rcp.collateral.CollateralTag;
import com.nxp.s32ds.rcp.collateral.core.CollateralFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CollateralManifestParserHandler
extends DefaultHandler {
    private final CollateralRegistry collateralRegistry;
    private final CollateralFactory factory;
    private Map<String, CollateralResource> resourcelId2CollateralResource;
    private Map<String, CollateralResourceType> resourceTypeIdId2CollateralResourceType;
    private Map<String, CollateralResource> collateralResourceFromRegistry;
    private Map<String, CollateralTag> taglId2CollateralResourceTag;
    private Map<String, CollateralFeature> featuresId2CollateralFeature;
    private Map<CollateralFeature, Set<String>> feature2SetOfCollateralResourceId;
    private Map<CollateralPack, Set<String>> pack2SetOfCollateralFeatureId;
    private Stack<CollateralResource> collateralResourceStack;
    private Stack<CollateralFeature> collateralFeatureStack;
    private Stack<CollateralPack> collateralPackStack;

    public CollateralManifestParserHandler(CollateralRegistry collateralRegistry) {
        this.collateralRegistry = collateralRegistry;
        this.factory = CollateralFactory.INSTANCE;
        this.resourcelId2CollateralResource = new HashMap<String, CollateralResource>();
        this.feature2SetOfCollateralResourceId = new HashMap<CollateralFeature, Set<String>>();
        this.pack2SetOfCollateralFeatureId = new HashMap<CollateralPack, Set<String>>();
        this.featuresId2CollateralFeature = new HashMap<String, CollateralFeature>();
        this.collateralResourceStack = new Stack();
        this.collateralFeatureStack = new Stack();
        this.collateralPackStack = new Stack();
        this.resourceTypeIdId2CollateralResourceType = new HashMap<String, CollateralResourceType>();
        this.taglId2CollateralResourceTag = new HashMap<String, CollateralTag>();
        this.collateralResourceFromRegistry = new HashMap<String, CollateralResource>();
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.clearData();
        this.initData();
    }

    private void initData() {
        this.resourceTypeIdId2CollateralResourceType = this.collateralRegistry.getAllResourceTypes().stream().collect(Collectors.toMap(CollateralObject::getId, resourceType -> resourceType));
        this.taglId2CollateralResourceTag = this.collateralRegistry.getAllCollateralTag().stream().collect(Collectors.toMap(CollateralObject::getId, tag -> tag));
        this.collateralResourceFromRegistry = this.collateralRegistry.getAllResources().stream().collect(Collectors.toMap(CollateralObject::getId, res -> res));
    }

    private void clearData() {
        this.featuresId2CollateralFeature.clear();
        this.resourcelId2CollateralResource.clear();
        this.resourceTypeIdId2CollateralResourceType.clear();
        this.taglId2CollateralResourceTag.clear();
        this.collateralFeatureStack.clear();
        this.feature2SetOfCollateralResourceId.clear();
        this.pack2SetOfCollateralFeatureId.clear();
        this.collateralPackStack.clear();
        this.collateralResourceFromRegistry.clear();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("resource")) {
            this.createCollateralResource(attributes);
        } else if (qName.equals("tags")) {
            this.validateModelForStartTags();
        } else if (qName.equals("tagId")) {
            this.addTagToCollateralResource(attributes);
        } else if (qName.equals("feature")) {
            this.createCollateralFeature(attributes);
        } else if (qName.equals("resources")) {
            this.validateModelForStartResources();
        } else if (qName.equals("resourceId")) {
            this.addResourceToCollateralFeature(attributes);
        } else if (qName.equals("pack")) {
            this.createCollateralPack(attributes);
        } else if (qName.equals("features")) {
            this.validateModelForStartFeatures();
        } else if (qName.equals("featureId")) {
            this.addFeatureToPack(attributes);
        }
    }

    private void addFeatureToPack(Attributes attributes) throws SAXException {
        String id = null;
        int i = 0;
        while (i < attributes.getLength()) {
            if ("id".equalsIgnoreCase(attributes.getQName(i))) {
                id = attributes.getValue(i);
            }
            ++i;
        }
        if (id == null || this.collateralPackStack.size() != 1) {
            throw new SAXException(Messages.CollateralManifestParserHandler_FeatureIdIsNullOrPackForFeatureNotExist);
        }
        Set<String> set = this.pack2SetOfCollateralFeatureId.get(this.collateralPackStack.lastElement());
        set.add(id);
    }

    private void createCollateralPack(Attributes attributes) throws SAXException {
        String id = null;
        String name = null;
        String description = null;
        String image = null;
        int i = 0;
        while (i < attributes.getLength()) {
            if ("id".equalsIgnoreCase(attributes.getQName(i))) {
                id = attributes.getValue(i);
            } else if ("name".equalsIgnoreCase(attributes.getQName(i))) {
                name = attributes.getValue(i);
            } else if ("description".equalsIgnoreCase(attributes.getQName(i))) {
                description = attributes.getValue(i);
            } else if ("image".equals(attributes.getQName(i))) {
                image = attributes.getValue(i);
            }
            ++i;
        }
        if (id == null) {
            throw new SAXException(Messages.CollateralManifestParserHandler_ResourceIdIsNull);
        }
        CollateralPack collateralPack = this.factory.createPack(id, name, description, image);
        this.pack2SetOfCollateralFeatureId.put(collateralPack, new HashSet());
        this.collateralPackStack.push(collateralPack);
    }

    private void validateModelForStartFeatures() throws SAXException {
        if (this.collateralPackStack.size() != 1) {
            throw new SAXException(Messages.CollateralManifestParserHandler_NotValidFileFeatures);
        }
    }

    private void addResourceToCollateralFeature(Attributes attributes) throws SAXException {
        String id = null;
        int i = 0;
        while (i < attributes.getLength()) {
            if ("id".equalsIgnoreCase(attributes.getQName(i))) {
                id = attributes.getValue(i);
            }
            ++i;
        }
        if (id == null || this.collateralFeatureStack.size() != 1) {
            throw new SAXException(Messages.CollateralManifestParserHandler_ResourceIdIsNullOrFeatureForResourceNotExist);
        }
        Set<String> set = this.feature2SetOfCollateralResourceId.get(this.collateralFeatureStack.lastElement());
        set.add(id);
    }

    private void validateModelForStartResources() throws SAXException {
        if (this.collateralFeatureStack.size() != 1) {
            throw new SAXException(Messages.CollateralManifestParserHandler_NotValidFileResource);
        }
    }

    private void addTagToCollateralResource(Attributes attributes) throws SAXException {
        String id = null;
        int i = 0;
        while (i < attributes.getLength()) {
            if ("id".equalsIgnoreCase(attributes.getQName(i))) {
                id = attributes.getValue(i);
                if (!this.taglId2CollateralResourceTag.keySet().contains(id)) {
                    throw new SAXException(Messages.bind((String)Messages.CollateralManifestParserHandler_NotExistTagWithId, (Object)id));
                }
            }
            ++i;
        }
        if (id == null) {
            throw new SAXException(Messages.CollateralManifestParserHandler_TagIdIsNull);
        }
        this.collateralRegistry.addCollateralTagToResource(this.taglId2CollateralResourceTag.get(id), (CollateralResource)this.collateralResourceStack.lastElement());
    }

    private void validateModelForStartTags() throws SAXException {
        if (this.collateralResourceStack.size() != 1) {
            throw new SAXException(Messages.CollateralManifestParserHandler_NotValidFileTags);
        }
    }

    private void createCollateralFeature(Attributes attributes) throws SAXException {
        String id = null;
        String name = null;
        String description = null;
        String image = null;
        int i = 0;
        while (i < attributes.getLength()) {
            if ("id".equalsIgnoreCase(attributes.getQName(i))) {
                id = attributes.getValue(i);
            } else if ("name".equalsIgnoreCase(attributes.getQName(i))) {
                name = attributes.getValue(i);
            } else if ("description".equalsIgnoreCase(attributes.getQName(i))) {
                description = attributes.getValue(i);
            } else if ("image".equals(attributes.getQName(i))) {
                image = attributes.getValue(i);
            }
            ++i;
        }
        if (id == null) {
            throw new SAXException(Messages.CollateralManifestParserHandler_FeatureIdIsNull);
        }
        CollateralFeature collateralFeature = this.factory.createFeature(id, name, description, image);
        this.feature2SetOfCollateralResourceId.put(collateralFeature, new HashSet());
        this.featuresId2CollateralFeature.put(collateralFeature.getId(), collateralFeature);
        this.collateralFeatureStack.push(collateralFeature);
    }

    private void createCollateralResource(Attributes attributes) throws SAXException {
        String id = null;
        String name = null;
        String description = null;
        String urlLink = null;
        String image = null;
        String resourceTypeId = null;
        int i = 0;
        while (i < attributes.getLength()) {
            if ("id".equalsIgnoreCase(attributes.getQName(i))) {
                id = attributes.getValue(i);
            } else if ("name".equalsIgnoreCase(attributes.getQName(i))) {
                name = attributes.getValue(i);
            } else if ("description".equalsIgnoreCase(attributes.getQName(i))) {
                description = attributes.getValue(i);
            } else if ("image".equals(attributes.getQName(i))) {
                image = attributes.getValue(i);
            } else if ("urlLink".equals(attributes.getQName(i))) {
                urlLink = attributes.getValue(i);
            } else if ("referenceResourceTypeId".equals(attributes.getQName(i))) {
                resourceTypeId = attributes.getValue(i);
                if (!this.resourceTypeIdId2CollateralResourceType.keySet().contains(resourceTypeId)) {
                    CollateralCoreActivator.getInstance().logWarning(Messages.bind((String)Messages.CollateralManifestParserHandler_NotExistResourceTypeWithId, (Object)resourceTypeId));
                }
            }
            ++i;
        }
        if (urlLink == null || id == null || resourceTypeId == null) {
            throw new SAXException(Messages.CollateralManifestParserHandler_RequaredAttribiteMissedForResource);
        }
        CollateralResource createResource = this.factory.createResource(id, name, description, urlLink, image);
        this.collateralRegistry.setCollateralResourceTypeToResource(this.resourceTypeIdId2CollateralResourceType.get(resourceTypeId), createResource);
        this.resourcelId2CollateralResource.put(createResource.getId(), createResource);
        this.collateralResourceStack.push(createResource);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("tags")) {
            this.validateModelForStartTags();
            this.collateralResourceStack.pop();
        } else if (qName.equals("resources")) {
            this.validateModelForStartResources();
            this.collateralFeatureStack.pop();
        } else if (qName.equals("features")) {
            this.validateModelForStartFeatures();
            this.collateralPackStack.pop();
        }
    }

    public void updateCollateralRegistry() {
        for (Map.Entry<CollateralFeature, Set<String>> entry : this.feature2SetOfCollateralResourceId.entrySet()) {
            for (String resourseId : entry.getValue()) {
                if (this.resourcelId2CollateralResource.containsKey(resourseId)) {
                    this.collateralRegistry.addCollateralResourceToFeature(this.resourcelId2CollateralResource.get(resourseId), entry.getKey());
                    continue;
                }
                if (this.collateralResourceFromRegistry.containsKey(resourseId)) {
                    this.collateralRegistry.addCollateralResourceToFeature(this.collateralResourceFromRegistry.get(resourseId), entry.getKey());
                    continue;
                }
                CollateralCoreActivator.getInstance().logWarning(Messages.bind((String)Messages.CollateralManifestParserHandler_ResourceIdNotFoudInRegitryAndFile, (Object)resourseId));
            }
        }
        for (Map.Entry<CollateralFeature, Set<String>> entry : this.pack2SetOfCollateralFeatureId.entrySet()) {
            for (String featureId : entry.getValue()) {
                if (this.featuresId2CollateralFeature.containsKey(featureId)) {
                    this.collateralRegistry.addCollateralFeatureToPack(this.featuresId2CollateralFeature.get(featureId), (CollateralPack)entry.getKey());
                    continue;
                }
                if (this.collateralRegistry.getFeatureById(featureId) != null) {
                    this.collateralRegistry.addCollateralFeatureToPack(this.collateralRegistry.getFeatureById(featureId), (CollateralPack)entry.getKey());
                    continue;
                }
                CollateralCoreActivator.getInstance().logWarning(Messages.CollateralManifestParserHandler_FeatureIdNotFoudInRegitryAndFile);
            }
        }
        this.pack2SetOfCollateralFeatureId.keySet().stream().forEach(arg_0 -> ((CollateralRegistry)this.collateralRegistry).addPack(arg_0));
    }
}

