/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service.internal;

import com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service.HardwareLaunchConfigurationActivator;
import com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service.HardwareLaunchConfigurationService;
import com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service.internal.LaunchConfigurationAttributesMapper;
import com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service.internal.LaunchConfigurationHardwareDataMapper;
import com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service.internal.ServiceErrorMessages;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;

public class HardwareLaunchConfigurationServiceImpl
implements HardwareLaunchConfigurationService {
    private Set<LaunchConfigurationAttributesMapper> lcAttributeNamesHolder = new HashSet<LaunchConfigurationAttributesMapper>();
    private Set<LaunchConfigurationHardwareDataMapper> hwDataHolder = new HashSet<LaunchConfigurationHardwareDataMapper>();

    @Override
    public DeviceCoreDescriptor getDeviceCoreDescriptor(ILaunchConfiguration config) {
        try {
            String typeId = config.getType().getIdentifier();
            LaunchConfigurationAttributesMapper mapper = this.findAttributeMapper(typeId);
            if (mapper != null) {
                Map attributes = config.getAttributes();
                String deviceCoreIdAttr = mapper.getLaunchConfigurationDeviceCoreIdAttribute();
                if (deviceCoreIdAttr != null) {
                    String deviceCoreId = (String)attributes.get(deviceCoreIdAttr);
                    return this.findDescriptorByDeviceCoreId(deviceCoreId);
                }
                String deviceAttrubute = mapper.getLaunchConfigurationDeviceAttribute();
                String coreAttrubute = mapper.getLaunchConfigurationCoreAttribute();
                String device = "";
                String core = "";
                if (deviceAttrubute != null) {
                    device = String.valueOf(attributes.getOrDefault(deviceAttrubute, ""));
                }
                if (coreAttrubute != null) {
                    core = String.valueOf(attributes.getOrDefault(coreAttrubute, ""));
                }
                return this.findDeviceCoreDescriptor(device, core, typeId);
            }
            HardwareLaunchConfigurationActivator.getInstance().logError(ServiceErrorMessages.ServiceError_no_attribute_mapper_found);
        }
        catch (CoreException ex) {
            HardwareLaunchConfigurationActivator.getInstance().log(ex.getStatus());
        }
        return null;
    }

    @Override
    public Map<String, Object> getDefaultParameters(String deviceCoreId, String launchConfigurationType) {
        return this.getParameters(deviceCoreId, launchConfigurationType, true);
    }

    @Override
    public Map<String, Object> getParameters(String deviceCoreId, String launchConfigurationType) {
        return this.getParameters(deviceCoreId, launchConfigurationType, false);
    }

    private Map<String, Object> getParameters(String deviceCoreId, String launchConfigurationType, boolean findDefault) {
        Optional<LaunchConfigurationHardwareDataMapper> optMapHolder;
        if (deviceCoreId == null || deviceCoreId.isEmpty()) {
            HardwareLaunchConfigurationActivator.getInstance().logError(ServiceErrorMessages.ServiceError_no_deviceCoreId_found);
            return Collections.emptyMap();
        }
        LaunchConfigurationAttributesMapper mapper = this.findAttributeMapper(launchConfigurationType);
        if (mapper == null) {
            HardwareLaunchConfigurationActivator.getInstance().logError(ServiceErrorMessages.ServiceError_no_attribute_mapper_found);
            return Collections.emptyMap();
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String deviceCoreIdAttr = mapper.getLaunchConfigurationDeviceCoreIdAttribute();
        if (deviceCoreIdAttr != null) {
            parameters.put(deviceCoreIdAttr, deviceCoreId);
            return parameters;
        }
        List mapHolders = this.hwDataHolder.stream().filter(holder -> holder.getDeviceCoreId().equals(deviceCoreId) && holder.getLcTypeId().equals(launchConfigurationType)).collect(Collectors.toList());
        if (mapHolders.isEmpty()) {
            HardwareLaunchConfigurationActivator.getInstance().logError(ServiceErrorMessages.ServiceError_no_device_core_values_found);
            return Collections.emptyMap();
        }
        LaunchConfigurationHardwareDataMapper mapHolder = (LaunchConfigurationHardwareDataMapper)mapHolders.get(0);
        if (findDefault && mapHolders.size() > 1 && (optMapHolder = mapHolders.stream().filter(holder -> holder.isDefault()).findFirst()).isPresent()) {
            mapHolder = optMapHolder.get();
        }
        String device = mapHolder.getDeviceId();
        String deviceAttr = mapper.getLaunchConfigurationDeviceAttribute();
        String deviceAttrType = mapper.getLaunchConfigurationDeviceAttributeType();
        if (deviceAttr != null && device != null) {
            this.putLCAttribute(parameters, deviceAttr, deviceAttrType, device);
        }
        String core = mapHolder.getCoreId();
        String coreAttr = mapper.getLaunchConfigurationCoreAttribute();
        String coreAttrType = mapper.getLaunchConfigurationCoreAttributeType();
        if (coreAttr != null && core != null) {
            this.putLCAttribute(parameters, coreAttr, coreAttrType, core);
        }
        return parameters;
    }

    private LaunchConfigurationAttributesMapper findAttributeMapper(String lcTypeId) {
        for (LaunchConfigurationAttributesMapper mapper : this.lcAttributeNamesHolder) {
            if (!mapper.getLaunchConfigurationType().equals(lcTypeId)) continue;
            return mapper;
        }
        return null;
    }

    private DeviceCoreDescriptor findDeviceCoreDescriptor(String device, String core, String lcTypeId) {
        String deviceCoreId = null;
        for (LaunchConfigurationHardwareDataMapper mapper : this.hwDataHolder) {
            String mapperCore;
            if (!mapper.getLcTypeId().equals(lcTypeId) || !mapper.getDeviceId().equals(device) || (mapperCore = mapper.getCoreId()) != null && !mapperCore.equals(core)) continue;
            deviceCoreId = mapper.getDeviceCoreId();
            break;
        }
        if (deviceCoreId == null) {
            HardwareLaunchConfigurationActivator.getInstance().logError(ServiceErrorMessages.ServiceError_no_deviceCoreId_found);
            return null;
        }
        return this.findDescriptorByDeviceCoreId(deviceCoreId);
    }

    private void putLCAttribute(Map<String, Object> holder, String attrName, String attrType, String attrVal) {
        String toPut = attrVal;
        if (attrType != null) {
            try {
                Class<?> clazz = Class.forName(attrType);
                Constructor<?> ctor = clazz.getConstructor(String.class);
                toPut = ctor.newInstance(attrVal);
            }
            catch (Exception ex) {
                HardwareLaunchConfigurationActivator.getInstance().logError(NLS.bind((String)ServiceErrorMessages.ServiceError_cannot_parse_lc_parameter_type, (Object)ex.getMessage()));
                return;
            }
        }
        holder.put(attrName, toPut);
    }

    private DeviceCoreDescriptor findDescriptorByDeviceCoreId(String deviceCoreId) {
        DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
        if (deviceCoreDescriptor == null) {
            HardwareLaunchConfigurationActivator.getInstance().logError(ServiceErrorMessages.ServiceError_no_DeviceCoreDescriptor_found);
            return null;
        }
        return deviceCoreDescriptor;
    }

    @Override
    public void addLaunchConfigurationMapper(LaunchConfigurationAttributesMapper launchConfigurationAttributesMapper) {
        this.lcAttributeNamesHolder.add(launchConfigurationAttributesMapper);
    }

    @Override
    public void addLaunchConfigurationHardwareDataMapper(LaunchConfigurationHardwareDataMapper launchConfigurationHardwareDataMapper) {
        this.hwDataHolder.add(launchConfigurationHardwareDataMapper);
    }
}

