/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources;

import com.nxp.s32ds.ext.ide.internal.resources.ResourcesMessages;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;

public class WorkspaceLaunchConfigurationNameValidator
implements IValidator<String> {
    public static final String ID = "workspace.launch.configuration.name.exists.validator";

    public IStatus validate(String value) {
        if (value == null) {
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ResourceNameValidator_e_name_invalid);
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        try {
            if (launchManager.isExistingLaunchConfigurationName(value)) {
                return new Status(4, "com.nxp.s32ds.ext.ide.resources", NLS.bind((String)ResourcesMessages.WorkspaceLaunchConfigurationNameValidatore_name_is_similar, (Object)value));
            }
        }
        catch (CoreException e) {
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", e.getMessage());
        }
        return Status.OK_STATUS;
    }
}

